/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;

public class BedBlock
extends HorizontalBlock
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> field_176472_a = BlockStateProperties.field_208139_an;
    public static final BooleanProperty field_176471_b = BlockStateProperties.field_208192_s;
    protected static final VoxelShape field_220176_c = Block.func_208617_a(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    protected static final VoxelShape field_220177_d = Block.func_208617_a(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape field_220178_e = Block.func_208617_a(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape field_220179_f = Block.func_208617_a(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape field_220180_g = Block.func_208617_a(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape field_220181_h = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220177_d, field_220179_f});
    protected static final VoxelShape field_220182_i = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220178_e, field_220180_g});
    protected static final VoxelShape field_220183_j = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220177_d, field_220178_e});
    protected static final VoxelShape field_220184_k = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220179_f, field_220180_g});
    private final DyeColor field_196352_y;

    public BedBlock(DyeColor colorIn, Block.Properties properties) {
        super(properties);
        this.field_196352_y = colorIn;
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176472_a, (Comparable)BedPart.FOOT))).func_206870_a((IProperty)field_176471_b, Boolean.valueOf(false))));
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177229_b((IProperty)field_176472_a) == BedPart.FOOT ? this.field_196352_y.func_196055_e() : MaterialColor.field_151659_e;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Direction func_220174_a(IBlockReader p_220174_0_, BlockPos p_220174_1_) {
        BlockState blockstate = p_220174_0_.func_180495_p(p_220174_1_);
        return blockstate.func_177230_c() instanceof BedBlock ? (Direction)((Object)blockstate.func_177229_b((IProperty)field_185512_D)) : null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b((IProperty)field_176472_a) != BedPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)((Object)state.func_177229_b((IProperty)field_185512_D))))).func_177230_c() != this) {
            return ActionResultType.CONSUME;
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != IForgeDimension.SleepResult.BED_EXPLODES) {
            if (sleepResult == IForgeDimension.SleepResult.DENY) {
                return ActionResultType.SUCCESS;
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176471_b)).booleanValue()) {
                if (!this.func_226861_a_(worldIn, pos)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied", new Object[0]), true);
                }
                return ActionResultType.SUCCESS;
            }
            player.func_213819_a(pos).ifLeft(p_220173_1_ -> {
                if (p_220173_1_ != null) {
                    player.func_146105_b(p_220173_1_.func_221259_a(), true);
                }
            });
            return ActionResultType.SUCCESS;
        }
        worldIn.func_217377_a(pos, false);
        BlockPos blockpos = pos.func_177972_a(((Direction)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_217377_a(blockpos, false);
        }
        worldIn.func_217401_a(null, DamageSource.func_199683_a(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
        return ActionResultType.SUCCESS;
    }

    private boolean func_226861_a_(World p_226861_1_, BlockPos p_226861_2_) {
        List<VillagerEntity> list = p_226861_1_.func_175647_a(VillagerEntity.class, new AxisAlignedBB(p_226861_2_), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).func_213366_dy();
        return true;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.func_226860_a_(entityIn);
        }
    }

    private void func_226860_a_(Entity p_226860_1_) {
        Vec3d vec3d = p_226860_1_.func_213322_ci();
        if (vec3d.field_72448_b < 0.0) {
            double d0 = p_226860_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226860_1_.func_213293_j(vec3d.field_72450_a, -vec3d.field_72448_b * (double)0.66f * d0, vec3d.field_72449_c);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == BedBlock.func_208070_a((BedPart)stateIn.func_177229_b((IProperty)field_176472_a), (Direction)((Object)stateIn.func_177229_b((IProperty)field_185512_D)))) {
            return facingState.func_177230_c() == this && facingState.func_177229_b((IProperty)field_176472_a) != stateIn.func_177229_b((IProperty)field_176472_a) ? (BlockState)((Object)stateIn.func_206870_a((IProperty)field_176471_b, facingState.func_177229_b((IProperty)field_176471_b))) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static Direction func_208070_a(BedPart p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.func_176734_d();
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BedPart bedpart = (BedPart)state.func_177229_b((IProperty)field_176472_a);
        BlockPos blockpos = pos.func_177972_a(BedBlock.func_208070_a(bedpart, (Direction)((Object)state.func_177229_b((IProperty)field_185512_D))));
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b((IProperty)field_176472_a) != bedpart) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j(blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                ItemStack itemstack = player.func_184614_ca();
                BedBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
                BedBlock.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
            }
            player.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)((Object)direction))) : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = BedBlock.func_226862_h_(state).func_176734_d();
        switch (direction) {
            case NORTH: {
                return field_220181_h;
            }
            case SOUTH: {
                return field_220182_i;
            }
            case WEST: {
                return field_220183_j;
            }
        }
        return field_220184_k;
    }

    public static Direction func_226862_h_(BlockState p_226862_0_) {
        Direction direction = (Direction)((Object)p_226862_0_.func_177229_b((IProperty)field_185512_D));
        return p_226862_0_.func_177229_b((IProperty)field_176472_a) == BedPart.HEAD ? direction.func_176734_d() : direction;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.Type func_226863_i_(BlockState p_226863_0_) {
        BedPart bedpart = (BedPart)p_226863_0_.func_177229_b((IProperty)field_176472_a);
        return bedpart == BedPart.HEAD ? TileEntityMerger.Type.FIRST : TileEntityMerger.Type.SECOND;
    }

    public static Optional<Vec3d> func_220172_a(EntityType<?> p_220172_0_, IWorldReader p_220172_1_, BlockPos p_220172_2_, int p_220172_3_) {
        Direction direction = (Direction)((Object)p_220172_1_.func_180495_p(p_220172_2_).func_177229_b((IProperty)field_185512_D));
        int i = p_220172_2_.func_177958_n();
        int j = p_220172_2_.func_177956_o();
        int k = p_220172_2_.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - direction.func_82601_c() * l - 1;
            int j1 = k - direction.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    Optional<Vec3d> optional = BedBlock.func_220175_a(p_220172_0_, p_220172_1_, blockpos);
                    if (!optional.isPresent()) continue;
                    if (p_220172_3_ <= 0) {
                        return optional;
                    }
                    --p_220172_3_;
                }
            }
        }
        return Optional.empty();
    }

    protected static Optional<Vec3d> func_220175_a(EntityType<?> p_220175_0_, IWorldReader p_220175_1_, BlockPos p_220175_2_) {
        VoxelShape voxelshape = p_220175_1_.func_180495_p(p_220175_2_).func_196952_d((IBlockReader)((Object)p_220175_1_), p_220175_2_);
        if (voxelshape.func_197758_c(Direction.Axis.Y) > 0.4375) {
            return Optional.empty();
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_220175_2_);
        while (blockpos$mutable.func_177956_o() >= 0 && p_220175_2_.func_177956_o() - blockpos$mutable.func_177956_o() <= 2 && p_220175_1_.func_180495_p((BlockPos)blockpos$mutable).func_196952_d((IBlockReader)((Object)p_220175_1_), (BlockPos)blockpos$mutable).func_197766_b()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        VoxelShape voxelshape1 = p_220175_1_.func_180495_p((BlockPos)blockpos$mutable).func_196952_d((IBlockReader)((Object)p_220175_1_), (BlockPos)blockpos$mutable);
        if (voxelshape1.func_197766_b()) {
            return Optional.empty();
        }
        double d0 = (double)blockpos$mutable.func_177956_o() + voxelshape1.func_197758_c(Direction.Axis.Y) + 2.0E-7;
        if ((double)p_220175_2_.func_177956_o() - d0 > 2.0) {
            return Optional.empty();
        }
        float f = p_220175_0_.func_220333_h() / 2.0f;
        Vec3d vec3d = new Vec3d((double)blockpos$mutable.func_177958_n() + 0.5, d0, (double)blockpos$mutable.func_177952_p() + 0.5);
        return p_220175_1_.func_226664_a_(new AxisAlignedBB(vec3d.field_72450_a - (double)f, vec3d.field_72448_b, vec3d.field_72449_c - (double)f, vec3d.field_72450_a + (double)f, vec3d.field_72448_b + (double)p_220175_0_.func_220344_i(), vec3d.field_72449_c + (double)f)) ? Optional.of(vec3d) : Optional.empty();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176472_a, field_176471_b});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BedTileEntity(this.field_196352_y);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)((Object)state.func_177229_b((IProperty)field_185512_D)));
            worldIn.func_180501_a(blockpos, (BlockState)((Object)state.func_206870_a((IProperty)field_176472_a, (Comparable)BedPart.HEAD)), 3);
            worldIn.func_195592_c(pos, Blocks.field_150350_a);
            state.func_196946_a(worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public DyeColor func_196350_d() {
        return this.field_196352_y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((Direction)((Object)state.func_177229_b((IProperty)field_185512_D)), state.func_177229_b((IProperty)field_176472_a) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

