/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.core.other;

import com.bagel.buzzierbees.core.other.BBTags;
import com.bagel.buzzierbees.core.registry.BBBlocks;
import com.bagel.buzzierbees.core.registry.BBItems;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="buzzierbees")
public class BBEvents {
    private static final Set<ResourceLocation> DESERT_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_186429_k});
    private static final Set<ResourceLocation> JUNGLE_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_186430_l});

    @SubscribeEvent
    public static void onInjectLoot(LootTableLoadEvent event) {
        LootPool pool;
        if (DESERT_LOOT_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("buzzierbees", "injections/desert_pyramid")).func_216086_a(1).func_216085_b(0)).name("desert_pyramid").func_216044_b();
            event.getTable().addPool(pool);
        }
        if (JUNGLE_LOOT_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("buzzierbees", "injections/jungle_temple")).func_216086_a(1).func_216085_b(0)).name("jungle_temple").func_216044_b();
            event.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public static void placeHangingPot(PlayerInteractEvent.RightClickBlock event) {
        boolean validPos;
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        ItemStack item = event.getItemStack();
        World world = event.getWorld();
        boolean bl = validPos = Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177984_a(), (Direction)event.getFace()) || world.func_180495_p(pos.func_177984_a()).func_177230_c().func_203417_a(BlockTags.field_206952_E);
        if ((event.getFace() == Direction.DOWN && validPos || world.func_180495_p(pos.func_177977_b()).func_196958_f() && world.func_180495_p(pos).func_196955_c((IWorldReader)world, pos) && validPos) && world.func_180495_p(pos).func_196958_f() && item.func_77973_b() == Blocks.field_150457_bL.func_199767_j()) {
            event.getWorld().func_175656_a(pos, ((Block)BBBlocks.HANGING_FLOWER_POT.get()).func_176223_P());
            event.getWorld().func_184133_a(event.getPlayer(), pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public static void potModdedItem(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        ItemStack item = event.getItemStack();
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        ResourceLocation pot = new ResourceLocation("buzzierbees:potted_" + item.func_77973_b().getRegistryName().func_110623_a());
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150457_bL && ForgeRegistries.BLOCKS.containsKey(pot) && item.func_77973_b().func_206844_a(BBTags.MODDED_POTTABLES)) {
            world.func_175656_a(pos, ((Block)ForgeRegistries.BLOCKS.getValue(pot)).func_176223_P());
            player.func_184609_a(event.getHand());
            player.func_195066_a(Stats.field_188088_V);
            if (!player.field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public static void bottleBug(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() != null && !event.getWorld().field_72995_K) {
            ItemStack itemstack = event.getPlayer().func_184586_b(event.getHand());
            Item item = itemstack.func_77973_b();
            Hand hand = Hand.MAIN_HAND;
            Item bottle = null;
            boolean successful = false;
            Entity target = event.getTarget();
            EntityType targetType = target.func_200600_R();
            PlayerEntity player = event.getPlayer();
            if (player.func_184614_ca().func_77973_b() == Items.field_151069_bo) {
                hand = Hand.MAIN_HAND;
            } else if (player.func_184592_cb().func_77973_b() == Items.field_151069_bo) {
                hand = Hand.OFF_HAND;
            }
            if (targetType == EntityType.field_200740_af) {
                bottle = (Item)BBItems.BOTTLE_OF_SILVERFISH.get();
                successful = true;
            }
            if (targetType == EntityType.field_200804_r) {
                bottle = (Item)BBItems.BOTTLE_OF_ENDERMITE.get();
                successful = true;
            }
            if (targetType == EntityType.field_226289_e_) {
                bottle = (Item)BBItems.BOTTLE_OF_BEE.get();
                successful = true;
            }
            ItemStack bottleItem = new ItemStack((IItemProvider)bottle);
            if (targetType == EntityType.field_226289_e_) {
                BeeEntity bee = (BeeEntity)target;
                CompoundNBT tag = bottleItem.func_196082_o();
                tag.func_74757_a("HasNectar", bee.func_226411_eD_());
                tag.func_74757_a("HasStung", bee.func_226412_eE_());
                tag.func_74768_a("Anger", bee.func_226418_eL_());
                tag.func_74768_a("Age", bee.func_70874_b());
                tag.func_74776_a("Health", bee.func_110143_aJ());
            }
            if (target.func_145818_k_()) {
                ITextComponent name = target.func_200201_e();
                bottleItem = bottleItem.func_200302_a(name);
            }
            if (successful && ((MobEntity)target).func_70089_S() && item == Items.field_151069_bo) {
                itemstack.func_190918_g(1);
                event.getWorld().func_184133_a(player, event.getPos(), SoundEvents.field_187618_I, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)event.getItemStack().func_77973_b()));
                player.func_184609_a(hand);
                event.getTarget().func_70106_y();
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, bottleItem);
                } else if (!player.field_71071_by.func_70441_a(bottleItem)) {
                    player.func_71019_a(bottleItem, false);
                }
            }
        }
    }
}

