/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.block;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import com.blakebr0.mysticalagradditions.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagradditions.item.EssenceCoalBlockItem;
import com.blakebr0.mysticalagradditions.item.ModItems;
import com.blakebr0.mysticalagradditions.lib.ModCorePlugin;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static final Map<RegistryObject<Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<RegistryObject<Block>, Supplier<Block>>();
    public static final RegistryObject<Block> INSANIUM_BLOCK = ModBlocks.register("insanium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f));
    public static final RegistryObject<Block> INSANIUM_INGOT_BLOCK = ModBlocks.register("insanium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f));
    public static final RegistryObject<Block> INSANIUM_GEMSTONE_BLOCK = ModBlocks.register("insanium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f));
    public static final RegistryObject<Block> INSANIUM_FARMLAND = ModBlocks.register("insanium_farmland", () -> new InfusedFarmlandBlock(ModCorePlugin.CROP_TIER_6));
    public static final RegistryObject<Block> INFERIUM_COAL_BLOCK = ModBlocks.register("inferium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 21600, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> PRUDENTIUM_COAL_BLOCK = ModBlocks.register("prudentium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 43200, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> TERTIUM_COAL_BLOCK = ModBlocks.register("tertium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 86400, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> IMPERIUM_COAL_BLOCK = ModBlocks.register("imperium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 172800, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> SUPREMIUM_COAL_BLOCK = ModBlocks.register("supremium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 345600, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> INSANIUM_COAL_BLOCK = ModBlocks.register("insanium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 691200, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> NETHER_STAR_CRUX = ModBlocks.register("nether_star_crux", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f));
    public static final RegistryObject<Block> DRAGON_EGG_CRUX = ModBlocks.register("dragon_egg_crux", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f));

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.forEach((reg, block) -> {
            registry.register((IForgeRegistryEntry)block.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get(), p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block, Function<RegistryObject<Block>, Supplier<? extends BlockItem>> item) {
        ResourceLocation loc = new ResourceLocation("mysticalagradditions", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        ModItems.BLOCK_ENTRIES.add(() -> (Item)((BlockItem)((Supplier)item.apply(reg)).get()).setRegistryName(loc));
        return reg;
    }
}

