/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketClient {
    private int type;
    private int[] data;

    public PacketClient(int type, int ... data) {
        this.type = type;
        this.data = data;
    }

    private PacketClient() {
    }

    public static PacketClient fromBytes(PacketBuffer buf) {
        PacketClient client = new PacketClient();
        client.type = buf.readByte();
        client.data = new int[buf.readByte()];
        for (int i = 0; i < client.data.length; ++i) {
            client.data[i] = buf.readInt();
        }
        return client;
    }

    public static void toBytes(PacketClient packet, PacketBuffer buf) {
        buf.writeByte(packet.type);
        buf.writeByte(packet.data.length);
        for (int i : packet.data) {
            buf.writeInt(i);
        }
    }

    public static void onMessage(final PacketClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71441_e != null) {
                    switch (message.type) {
                        case 0: {
                            int goalDim = message.data[0];
                            BlockPos goalPos = new BlockPos(message.data[1], message.data[2], message.data[3]);
                            ItemRangeVisualizer.visualize((PlayerEntity)mc.field_71439_g, ItemRangeVisualizer.VISUALIZED_RAILS, DimensionType.func_186069_a((int)goalDim), goalPos);
                        }
                        case 1: {
                            Entity entity = mc.field_71441_e.func_73045_a(message.data[0]);
                            mc.field_71452_i.func_199281_a(entity, (IParticleData)ParticleTypes.field_197604_O, 30);
                            mc.field_71441_e.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_191263_gW, entity.func_184176_by(), 1.0f, 1.0f, false);
                            if (entity != mc.field_71439_g) break;
                            mc.field_71460_t.func_190565_a(new ItemStack((IItemProvider)ModItems.DEATH_RING));
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

