/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderEnderCrate;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockEnderCrate
extends BlockContainerImpl
implements ITESRProvider<TileEntityEnderCrate>,
ICustomBlockState {
    private static final ThreadLocal<WeakReference<World>> CACHED_WORLD = new ThreadLocal();

    public BlockEnderCrate() {
        super("ender_crate", TileEntityEnderCrate::new, ModBlocks.prop(Material.field_151576_e).func_200943_b(5.0f).func_200951_a(7).func_200947_a(SoundType.field_185851_d));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static String getEnderName(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "";
        }
        return stack.func_77978_p().func_74779_i("naturesaura:ender_name");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addEnderNameInfo(ItemStack stack, List<ITextComponent> tooltip) {
        String name = BlockEnderCrate.getEnderName(stack);
        if (name != null && !name.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.naturesaura.ender_name", (Object[])new Object[]{TextFormatting.ITALIC + name + TextFormatting.RESET})));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.naturesaura.ender_name.missing", (Object[])new Object[0])));
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos = event.getPos());
        if (state.func_177230_c() instanceof AnvilBlock) {
            CACHED_WORLD.set(new WeakReference<World>(world));
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        WeakReference<World> world = CACHED_WORLD.get();
        if (world == null || world.get() == null) {
            return;
        }
        ItemStack stack = event.getLeft();
        if (stack.func_77973_b() != Item.func_150898_a((Block)this) && stack.func_77973_b() != ModItems.ENDER_ACCESS) {
            return;
        }
        ItemStack second = event.getRight();
        if (second.func_77973_b() != Items.field_151061_bv || second.func_190916_E() < stack.func_190916_E()) {
            return;
        }
        String name = event.getName();
        if (name == null || name.isEmpty()) {
            return;
        }
        if (IWorldData.getOverworldData((World)world.get()).isEnderStorageLocked(name)) {
            return;
        }
        ItemStack output = stack.func_77946_l();
        output.func_196082_o().func_74778_a("naturesaura:ender_name", name);
        event.setOutput(output);
        event.setMaterialCost(stack.func_190916_E());
        event.setCost(1);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntityEnderCrate crate;
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityEnderCrate && (crate = (TileEntityEnderCrate)tile).canOpen()) {
            crate.drainAura(10000);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)crate, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockEnderCrate.addEnderNameInfo(stack, tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 3; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public Tuple<TileEntityType<TileEntityEnderCrate>, Supplier<Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super TileEntityEnderCrate>>>> getTESR() {
        return new Tuple(ModTileEntities.ENDER_CRATE, () -> RenderEnderCrate::new);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

