/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.entity;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.render.tile.RenderTileEnderTank;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.fluids.FluidStack;

public class TankLayerRenderer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final String[] UUID_STRINGS = new String[]{"c85f3fd3-1754-45ec-ab3d-a33d6312dfef", "c501d550-7e3c-463e-8a95-256f86d9a47d", "cf3e2c7e-d703-48e0-808e-f139bf26ff9d", "44ba40ef-fd8a-446f-834b-5aea42119c92"};
    private static final Set<UUID> UUIDS = Arrays.stream(UUID_STRINGS).map(UUID::fromString).collect(Collectors.toSet());
    private static final Frequency BLANK = new Frequency();

    public TankLayerRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, AbstractClientPlayerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (UUIDS.contains(entity.func_110124_au())) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.brightness = packedLight;
            ccrs.overlay = OverlayTexture.field_229196_a_;
            Matrix4 mat = new Matrix4(mStack);
            mat.rotate(3.1415926535897403, Vector3.X_POS);
            mat.scale(0.5);
            if (entity.func_225608_bj_()) {
                mat.translate(0.0, -0.5, 0.0);
            }
            if (entity.func_184613_cA()) {
                headPitch = -45.0f;
            }
            mat.rotate((double)netHeadYaw * 0.017453292519943, Vector3.Y_NEG);
            mat.rotate((double)headPitch * 0.017453292519943, Vector3.X_POS);
            mat.translate(-0.5, 1.0, -0.5);
            RenderTileEnderTank.renderTank(ccrs, mat, getter, 0, 1.5707964f, 0.0, BLANK, 0);
            FluidStack stack = FluidUtils.water.copy();
            float bob = 0.45f + RenderUtils.getPearlBob((double)ClientUtils.getRenderTime()) * 2.0f;
            stack.setAmount((int)MathHelper.map((double)bob, (double)0.2, (double)0.6, (double)1000.0, (double)14000.0));
            mat.translate(-0.5, 0.0, -0.5);
            RenderTileEnderTank.renderFluid(ccrs, mat, getter, stack);
        }
    }
}

