/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.utils;

import com.google.common.collect.HashBiMap;
import java.util.Locale;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;

public class BlockDeserializationHelper {
    public static final BlockDeserializationHelper INSTANCE = new BlockDeserializationHelper();
    private static final HashBiMap<String, Material> BLOCK_MATERIALS = HashBiMap.create();
    private static final HashBiMap<String, SoundType> SOUND_TYPES = HashBiMap.create();

    private BlockDeserializationHelper() {
    }

    public Material getBlockMaterial(String name) {
        return (Material)BLOCK_MATERIALS.get((Object)name.toLowerCase(Locale.US));
    }

    public String getBlockMaterialName(Material material) {
        return (String)BLOCK_MATERIALS.inverse().get((Object)material);
    }

    public void putBlockMaterial(String name, Material material) {
        BLOCK_MATERIALS.put((Object)name.toLowerCase(Locale.US), (Object)material);
    }

    public SoundType getSoundType(String name) {
        return (SoundType)SOUND_TYPES.get((Object)name.toLowerCase(Locale.US));
    }

    public String getSoundTypeName(SoundType sound) {
        return (String)SOUND_TYPES.inverse().get((Object)sound);
    }

    public void putSoundType(String name, SoundType sound) {
        SOUND_TYPES.put((Object)name.toLowerCase(Locale.US), (Object)sound);
    }

    static {
        INSTANCE.putBlockMaterial("air", Material.field_151579_a);
        INSTANCE.putBlockMaterial("structure_void", Material.field_189963_J);
        INSTANCE.putBlockMaterial("portal", Material.field_151567_E);
        INSTANCE.putBlockMaterial("carpet", Material.field_151593_r);
        INSTANCE.putBlockMaterial("plants", Material.field_151585_k);
        INSTANCE.putBlockMaterial("ocean_plant", Material.field_203243_f);
        INSTANCE.putBlockMaterial("tall_plants", Material.field_151582_l);
        INSTANCE.putBlockMaterial("sea_grass", Material.field_204868_h);
        INSTANCE.putBlockMaterial("water", Material.field_151586_h);
        INSTANCE.putBlockMaterial("bubble_column", Material.field_203244_i);
        INSTANCE.putBlockMaterial("lava", Material.field_151587_i);
        INSTANCE.putBlockMaterial("snow", Material.field_151597_y);
        INSTANCE.putBlockMaterial("fire", Material.field_151581_o);
        INSTANCE.putBlockMaterial("miscellaneous", Material.field_151594_q);
        INSTANCE.putBlockMaterial("web", Material.field_151569_G);
        INSTANCE.putBlockMaterial("redstone_light", Material.field_151591_t);
        INSTANCE.putBlockMaterial("clay", Material.field_151571_B);
        INSTANCE.putBlockMaterial("earth", Material.field_151578_c);
        INSTANCE.putBlockMaterial("organic", Material.field_151577_b);
        INSTANCE.putBlockMaterial("packed_ice", Material.field_151598_x);
        INSTANCE.putBlockMaterial("sand", Material.field_151595_p);
        INSTANCE.putBlockMaterial("sponge", Material.field_151583_m);
        INSTANCE.putBlockMaterial("shulker", Material.field_215711_w);
        INSTANCE.putBlockMaterial("wood", Material.field_151575_d);
        INSTANCE.putBlockMaterial("bamboo_sapling", Material.field_215712_y);
        INSTANCE.putBlockMaterial("bamboo", Material.field_215713_z);
        INSTANCE.putBlockMaterial("wool", Material.field_151580_n);
        INSTANCE.putBlockMaterial("tnt", Material.field_151590_u);
        INSTANCE.putBlockMaterial("leaves", Material.field_151584_j);
        INSTANCE.putBlockMaterial("glass", Material.field_151592_s);
        INSTANCE.putBlockMaterial("ice", Material.field_151588_w);
        INSTANCE.putBlockMaterial("cactus", Material.field_151570_A);
        INSTANCE.putBlockMaterial("rock", Material.field_151576_e);
        INSTANCE.putBlockMaterial("iron", Material.field_151573_f);
        INSTANCE.putBlockMaterial("snow_block", Material.field_151596_z);
        INSTANCE.putBlockMaterial("anvil", Material.field_151574_g);
        INSTANCE.putBlockMaterial("barrier", Material.field_175972_I);
        INSTANCE.putBlockMaterial("piston", Material.field_76233_E);
        INSTANCE.putBlockMaterial("coral", Material.field_151589_v);
        INSTANCE.putBlockMaterial("gourd", Material.field_151572_C);
        INSTANCE.putBlockMaterial("dragon_egg", Material.field_151566_D);
        INSTANCE.putBlockMaterial("cake", Material.field_151568_F);
        INSTANCE.putSoundType("wood", SoundType.field_185848_a);
        INSTANCE.putSoundType("ground", SoundType.field_185849_b);
        INSTANCE.putSoundType("plant", SoundType.field_185850_c);
        INSTANCE.putSoundType("stone", SoundType.field_185851_d);
        INSTANCE.putSoundType("metal", SoundType.field_185852_e);
        INSTANCE.putSoundType("glass", SoundType.field_185853_f);
        INSTANCE.putSoundType("cloth", SoundType.field_185854_g);
        INSTANCE.putSoundType("sand", SoundType.field_185855_h);
        INSTANCE.putSoundType("snow", SoundType.field_185856_i);
        INSTANCE.putSoundType("ladder", SoundType.field_185857_j);
        INSTANCE.putSoundType("anvil", SoundType.field_185858_k);
        INSTANCE.putSoundType("slime", SoundType.field_185859_l);
        INSTANCE.putSoundType("wet_grass", SoundType.field_211382_m);
        INSTANCE.putSoundType("coral", SoundType.field_211383_n);
        INSTANCE.putSoundType("bamboo", SoundType.field_222468_o);
        INSTANCE.putSoundType("bamboo_sapling", SoundType.field_222469_p);
        INSTANCE.putSoundType("scaffolding", SoundType.field_222470_q);
        INSTANCE.putSoundType("sweet_berry_bush", SoundType.field_222471_r);
        INSTANCE.putSoundType("crop", SoundType.field_222472_s);
        INSTANCE.putSoundType("stem", SoundType.field_222473_t);
        INSTANCE.putSoundType("nether_wart", SoundType.field_222474_u);
        INSTANCE.putSoundType("lantern", SoundType.field_222475_v);
    }
}

