/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.uselessmod;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.uselessmod.UselessModHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"uselessmod"})
public class UselessModCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("coal", "diamond", "emerald", "gold", "iron", "super_useless", "useless"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("gold", "iron", "super_useless", "useless"));

    @Override
    public String getName() {
        return "uselessmod_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        UselessModHelper helper = UselessModHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            if (!ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) && !TO_DUST_BLACKLIST.contains(material.getName())) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerCrushingRecipe(new ResourceLocation("jaopca", "uselessmod.material_to_dust." + material.getName()), materialLocation, dustLocation, 1, 2.3f, 200);
                }
            }
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) || TO_PLATE_BLACKLIST.contains(material.getName())) continue;
            materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(plateLocation)) continue;
            helper.registerCompressingRecipe(new ResourceLocation("jaopca", "uselessmod.material_to_plate." + material.getName()), materialLocation, plateLocation, 1, 0.5f, 100);
        }
    }

    static {
        if (ModList.get().isLoaded("silents_mechanisms")) {
            Collections.addAll(TO_DUST_BLACKLIST, "aluminum", "bismuth", "copper", "lead", "nickel", "platinum", "silver", "tin", "uranium", "zinc");
        }
    }
}

