/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.ButtonClickPacket;

public abstract class ContainerScreenExtended<T extends ContainerExtended>
extends ContainerScreen<T>
implements IValueNotifiable {
    protected T field_147002_h;
    protected ResourceLocation texture;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public ContainerScreenExtended(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        ((ContainerExtended)container).setGuiValueListener(this);
        this.field_147002_h = container;
        this.texture = this.constructGuiTexture();
    }

    protected abstract ResourceLocation constructGuiTexture();

    public ResourceLocation getGuiTexture() {
        return this.texture;
    }

    public void init() {
        this.field_146999_f = this.getBaseXSize() + this.offsetX * 2;
        this.field_147000_g = this.getBaseYSize() + this.offsetY * 2;
        super.init();
    }

    public final void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCurrentScreen(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 166;
    }

    protected void func_146976_a(float f, int x, int y) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelpers.bindTexture(this.texture);
        this.blit(this.field_147003_i + this.offsetX, this.field_147009_r + this.offsetY, 0, 0, this.field_146999_f - 2 * this.offsetX, this.field_147000_g - 2 * this.offsetY);
    }

    public boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        return this.func_195359_a(slotIn.field_75223_e - 1, slotIn.field_75221_f - 1, GuiHelpers.SLOT_SIZE, GuiHelpers.SLOT_SIZE, mouseX, mouseY);
    }

    public boolean func_195359_a(int left, int top, int right, int bottom, double pointX, double pointY) {
        return RenderHelpers.isPointInRegion(left, top, right, bottom, pointX - (double)this.field_147003_i, pointY - (double)this.field_147009_r);
    }

    public boolean isPointInRegion(Rectangle region, Point mouse) {
        return this.func_195359_a(region.x, region.y, region.width, region.height, mouse.x, mouse.y);
    }

    public void drawTooltip(List<ITextComponent> lines, int x, int y) {
        GuiHelpers.drawTooltip(this, lines, x, y);
    }

    protected Button.IPressable createServerPressable(String buttonId, @Nullable Button.IPressable clientPressable) {
        return button -> {
            if (clientPressable != null) {
                clientPressable.onPress(button);
            }
            if (((ContainerExtended)this.func_212873_a_()).onButtonClick(buttonId)) {
                CyclopsCore._instance.getPacketHandler().sendToServer(new ButtonClickPacket(buttonId));
            }
        };
    }

    @Override
    public void onUpdate(int valueId, CompoundNBT value) {
    }

    protected void refreshValues() {
        for (int id : ((ContainerExtended)this.func_212873_a_()).getValueIds()) {
            this.onUpdate(id, ((ContainerExtended)this.func_212873_a_()).getValue(id));
        }
    }

    public int getGuiLeftTotal() {
        return this.field_147003_i + this.offsetX;
    }

    public int getGuiTopTotal() {
        return this.field_147009_r + this.offsetY;
    }

    @Override
    public ContainerType<?> getType() {
        return ((ContainerExtended)this.func_212873_a_()).func_216957_a();
    }
}

