/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.state.Property;

public class Tools {
    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer, String error) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static <INPUT extends BASE, BASE, RET> RET safeMap(BASE o, Function<INPUT, RET> consumer, String error) {
        try {
            return consumer.apply(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    private static <T extends Comparable<T>> String getValueName(Property<T> property, Object value) {
        return property.func_177702_a((Comparable)value);
    }

    private static void permutateProperties(Consumer<String> consumer, String left, Property<?> ... properties) {
        if (properties.length > 0) {
            Property[] tail = new Property[properties.length - 1];
            System.arraycopy(properties, 1, tail, 0, properties.length - 1);
            String name = properties[0].func_177701_a();
            for (Comparable value : properties[0].func_177700_c()) {
                Tools.permutateProperties(consumer, (left.isEmpty() ? "" : left + ",") + name + "=" + Tools.getValueName(properties[0], value), tail);
            }
        } else {
            consumer.accept(left);
        }
    }

    public static void permutateProperties(Consumer<String> consumer, Property<?> ... properties) {
        Tools.permutateProperties(consumer, "", properties);
    }
}

