/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TeleportationTools {
    public static void performTeleport(PlayerEntity player, DimensionType dimension, BlockPos dest, @Nullable Direction direction) {
        TeleportationTools.performTeleport(player, dimension, (double)dest.func_177958_n() + 0.5, (double)dest.func_177956_o() + 1.5, (double)dest.func_177952_p() + 0.5, direction);
    }

    public static void performTeleport(PlayerEntity player, DimensionType dimension, double destX, double destY, double destZ, @Nullable Direction direction) {
        DimensionType oldId = player.func_130014_f_().func_201675_m().func_186058_p();
        float rotationYaw = player.field_70177_z;
        float rotationPitch = player.field_70125_A;
        if (!oldId.equals(dimension)) {
            TeleportationTools.teleportToDimension(player, dimension, destX, destY, destZ);
        }
        if (direction != null) {
            TeleportationTools.fixOrientation((Entity)player, destX, destY, destZ, direction);
        } else {
            player.field_70177_z = rotationYaw;
            player.field_70125_A = rotationPitch;
        }
        player.func_70634_a(destX, destY, destZ);
    }

    public static World getWorldForDimension(DimensionType type) {
        ServerWorld w = WorldTools.getWorld(type);
        if (w == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            w = server.func_71218_a(type);
        }
        return w;
    }

    public static void teleportToDimension(PlayerEntity player, DimensionType dimension, double x, double y, double z) {
        DimensionType oldDimension = player.func_130014_f_().func_201675_m().func_186058_p();
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        MinecraftServer server = player.func_130014_f_().func_73046_m();
        ServerWorld worldServer = server.func_71218_a(dimension);
        if (worldServer == null) {
            return;
        }
        player.func_82242_a(0);
        TeleportationTools.changeDim(serverPlayer, new BlockPos(x, y, z), dimension);
    }

    public static void changeDim(ServerPlayerEntity player, BlockPos pos, DimensionType type) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (DimensionType)type)) {
            return;
        }
        DimensionType dimensiontype = player.field_71093_bK;
        ServerWorld srcWorld = player.field_71133_b.func_71218_a(dimensiontype);
        player.field_71093_bK = type;
        ServerWorld destWorld = player.field_71133_b.func_71218_a(type);
        WorldInfo worldinfo = player.field_70170_p.func_72912_H();
        player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(type, WorldInfo.func_227498_c_((long)worldinfo.func_76063_b()), worldinfo.func_76067_t(), player.field_71134_c.func_73081_b()));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = player.field_71133_b.func_184103_al();
        playerlist.func_187243_f(player);
        srcWorld.removeEntity((Entity)player, true);
        player.revive();
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        player.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, f1, f);
        srcWorld.func_217381_Z().func_76319_b();
        srcWorld.func_217381_Z().func_76320_a("placing");
        player.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, f1, f);
        srcWorld.func_217381_Z().func_76319_b();
        player.func_70029_a((World)destWorld);
        destWorld.func_217447_b(player);
        player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, f1, f);
        player.field_71134_c.func_73080_a(destWorld);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerlist.func_72354_b(player, destWorld);
        playerlist.func_72385_f(player);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (DimensionType)dimensiontype, (DimensionType)type);
    }

    private static void facePosition(Entity entity, double newX, double newY, double newZ, BlockPos dest) {
        double d0 = (double)dest.func_177958_n() - newX;
        double d1 = (double)dest.func_177956_o() - (newY + (double)entity.func_70047_e());
        double d2 = (double)dest.func_177952_p() - newZ;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        entity.field_70125_A = TeleportationTools.updateRotation(entity.field_70125_A, f1);
        entity.field_70177_z = TeleportationTools.updateRotation(entity.field_70177_z, f);
    }

    private static float updateRotation(float angle, float targetAngle) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        return angle + f;
    }

    public static Entity teleportEntity(Entity entity, World destWorld, double newX, double newY, double newZ, Direction facing) {
        World world = entity.func_130014_f_();
        if (entity instanceof PlayerEntity) {
            TeleportationTools.performTeleport((PlayerEntity)entity, destWorld.func_201675_m().func_186058_p(), newX, newY, newZ, facing);
            return entity;
        }
        float rotationYaw = entity.field_70177_z;
        float rotationPitch = entity.field_70125_A;
        if (world.func_201675_m().func_186058_p() != destWorld.func_201675_m().func_186058_p()) {
            CompoundNBT tagCompound = new CompoundNBT();
            entity.func_184198_c(tagCompound);
            tagCompound.func_82580_o("Dimension");
            EntityType type = entity.func_200600_R();
            ((ServerWorld)world).func_217467_h(entity);
            entity.revive();
            ((ServerWorld)world).func_217479_a(entity);
            Entity newEntity = type.func_200721_a(destWorld);
            newEntity.func_70020_e(tagCompound);
            if (facing != null) {
                TeleportationTools.fixOrientation(newEntity, newX, newY, newZ, facing);
            } else {
                newEntity.field_70177_z = rotationYaw;
                newEntity.field_70125_A = rotationPitch;
            }
            newEntity.func_70012_b(newX, newY, newZ, newEntity.field_70177_z, newEntity.field_70125_A);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            destWorld.func_217376_c(newEntity);
            newEntity.field_98038_p = flag;
            ((ServerWorld)world).func_217479_a(newEntity);
            entity.func_70106_y();
            ((ServerWorld)world).func_82742_i();
            ((ServerWorld)destWorld).func_82742_i();
            return newEntity;
        }
        if (facing != null) {
            TeleportationTools.fixOrientation(entity, newX, newY, newZ, facing);
        } else {
            entity.field_70177_z = rotationYaw;
            entity.field_70125_A = rotationPitch;
        }
        entity.func_70012_b(newX, newY, newZ, entity.field_70177_z, entity.field_70125_A);
        ((ServerWorld)destWorld).func_217479_a(entity);
        return entity;
    }

    private static void fixOrientation(Entity entity, double newX, double newY, double newZ, Direction facing) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            TeleportationTools.facePosition(entity, newX, newY, newZ, new BlockPos(newX, newY, newZ).func_177967_a(facing, 4));
        }
    }
}

