/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.typed.Type;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class TextPage
extends AbstractWidget<TextPage> {
    public static final String TYPE_TEXTPAGE = "textpage";
    private ModBase modBase;
    private final List<Page> pages = new ArrayList<Page>();
    private final Map<String, Integer> nodes = new HashMap<String, Integer>();
    private int pageIndex = 0;
    private final List<Line> lines = new ArrayList<Line>();
    private final List<Link> links = new ArrayList<Link>();
    private ResourceLocation arrowImage = null;
    private int arrowU;
    private int arrowV;
    private ResourceLocation craftingGridImage = null;
    private int craftU;
    private int craftV;
    private int tabCounter = 0;

    public TextPage(ModBase modBase, Minecraft mc, Screen gui) {
        super(mc, gui);
        this.modBase = modBase;
    }

    public TextPage setArrowImage(ResourceLocation image, int u, int v) {
        this.arrowImage = image;
        this.arrowU = u;
        this.arrowV = v;
        return this;
    }

    public TextPage setCraftingGridImage(ResourceLocation image, int u, int v) {
        this.craftingGridImage = image;
        this.craftU = u;
        this.craftV = v;
        return this;
    }

    private void setPage(Page page) {
        this.lines.clear();
        this.links.clear();
        if (!this.pages.isEmpty()) {
            int y = 3;
            int tab = 0;
            for (Line line : page.lines) {
                this.lines.add(line);
                if (line.isNexttab()) {
                    y = 3;
                    ++tab;
                } else if (line.isLink()) {
                    this.links.add(new Link(tab, y, y + 13, line.node));
                }
                y += line.height;
            }
        }
    }

    private void newPage(Page page) {
        if (!page.isEmpty()) {
            this.pages.add(page);
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    private IResource getBestLanguageManual(ResourceLocation manualResource) throws IOException {
        IResourceManager resourceManager = this.mc.func_195551_G();
        try {
            return resourceManager.func_199002_a(manualResource);
        }
        catch (FileNotFoundException e) {
            String fallBackPath = manualResource.func_110623_a().replaceAll("-([a-z\\-]{2,6})_?([a-z]{0,3})", "");
            return resourceManager.func_199002_a(new ResourceLocation(manualResource.func_110624_b(), fallBackPath));
        }
    }

    public TextPage setText(ResourceLocation manualResource) {
        Page page = new Page();
        try (IResource iresource = this.getBestLanguageManual(manualResource);
             BufferedReader br = new BufferedReader(new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("{------")) {
                    this.newPage(page);
                    page = new Page();
                    continue;
                }
                Line l = page.addLine(this.modBase, line);
                if (!l.isNode()) continue;
                this.nodes.put(l.node, this.pages.size());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading manual text", e);
        }
        this.newPage(page);
        this.showCurrentPage();
        return this;
    }

    public void prevPage() {
        --this.pageIndex;
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        }
        this.showCurrentPage();
    }

    public void nextPage() {
        ++this.pageIndex;
        if (this.pageIndex >= this.pages.size()) {
            this.pageIndex = this.pages.size() - 1;
        }
        this.showCurrentPage();
    }

    private void showCurrentPage() {
        this.setPage(this.pages.get(this.pageIndex));
    }

    public TextPage mouseClick(int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            this.window.setTextFocus(this);
            for (Link link : this.links) {
                int t;
                if (this.tabCounter == 0) {
                    if (link.y1 > y || y > link.y2 || !this.gotoLink(link)) continue;
                    return this;
                }
                int n = t = x < this.getBounds().width / 2 ? 0 : 1;
                if (link.y1 > y || y > link.y2 || link.tab != t || !this.gotoLink(link)) continue;
                return this;
            }
            return this;
        }
        return null;
    }

    private boolean gotoLink(Link link) {
        String node = link.node;
        return this.gotoNode(node);
    }

    public boolean gotoNode(String node) {
        Integer page = this.nodes.get(node);
        if (page != null) {
            this.pageIndex = page;
            this.showCurrentPage();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(int keyCode, int scanCode) {
        boolean rc = super.keyTyped(keyCode, scanCode);
        if (rc) {
            return true;
        }
        if (this.isEnabledAndVisible()) {
            if (keyCode == 259 || keyCode == 263) {
                this.prevPage();
                return true;
            }
            if (keyCode == 32 || keyCode == 262) {
                this.nextPage();
                return true;
            }
            if (keyCode == 268) {
                this.pageIndex = 0;
                this.showCurrentPage();
            } else if (keyCode == 269 && !this.pages.isEmpty()) {
                this.pageIndex = this.pages.size() - 1;
                this.showCurrentPage();
            }
        }
        return false;
    }

    @Override
    public void draw(int x, int y) {
        super.draw(x, y);
        this.tabCounter = 0;
        int starty = y += 3;
        for (Line line : this.lines) {
            if (line.isNexttab()) {
                y = starty;
                x += this.getBounds().width / 2;
                ++this.tabCounter;
            } else if (line.recipe != null) {
                y = this.renderRecipe(x, y, line);
            } else if (line.resourceLocation != null) {
                this.renderImage(x, y, line);
            } else if (line.line != null) {
                this.renderLine(x, y, line);
            }
            y += line.height;
        }
    }

    private void renderImage(int x, int y, Line line) {
        char c;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(line.resourceLocation);
        this.gui.blit(x + 4, y + 1, line.u, line.v, 16, 16);
        int dx = 22;
        String s = "";
        int col = -16777216;
        if (line.isBold()) {
            c = '\u00a7';
            s = Character.toString(c) + "l";
        }
        if (line.isLink()) {
            c = '\u00a7';
            s = Character.toString(c) + "n";
            col = -16760662;
            dx = 25;
        }
        s = s + line.line;
        this.mc.field_71466_p.func_211126_b(this.mc.field_71466_p.func_78269_a(s, this.bounds.width - dx), (float)(x + dx + this.bounds.x), (float)(y + this.bounds.y + 3), col);
    }

    private void renderLine(int x, int y, Line line) {
        char c;
        String s = "";
        int col = -16777216;
        int dx = 0;
        if (line.isBold()) {
            c = '\u00a7';
            s = Character.toString(c) + "l";
        }
        if (line.isLink()) {
            c = '\u00a7';
            s = Character.toString(c) + "n";
            col = -16760662;
            dx = 25;
        }
        s = s + line.line;
        this.mc.field_71466_p.func_211126_b(this.mc.field_71466_p.func_78269_a(s, this.bounds.width - dx), (float)(x + dx + this.bounds.x), (float)(y + this.bounds.y), col);
    }

    private int renderRecipe(int x, int y, Line line) {
        y += 4;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.craftingGridImage != null) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.craftingGridImage);
            this.gui.blit(25 + x, y, this.craftU, this.craftV, 57, 57);
        }
        int w = 0;
        int h = 0;
        Object ingredients = null;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Ingredient ingredient;
                if (i >= w || j >= h || (ingredient = (Ingredient)ingredients.get(i + j * w)).func_193365_a().length <= 0) continue;
                ItemStack stack = ingredient.func_193365_a()[0];
                if (stack != null && stack.func_77952_i() == Short.MAX_VALUE) {
                    CompoundNBT tc = stack.func_77978_p();
                    stack = new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E());
                    if (tc != null) {
                        stack.func_77982_d(tc.func_74737_b());
                    }
                }
                RenderHelper.renderObject(this.mc, 26 + x + i * 18, 1 + y + j * 18, stack, false);
            }
        }
        if (this.arrowImage != null) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.arrowImage);
            this.gui.blit(x + 25 + 67, y + 18, this.arrowU, this.arrowV, 16, 16);
        }
        if (this.craftingGridImage != null) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.craftingGridImage);
            this.gui.blit(x + 25 + 92, y + 16, this.craftU, this.craftV, 18, 18);
        }
        RenderHelper.renderObject(this.mc, x + 25 + 93, y + 17, line.recipe.func_77571_b(), false);
        return y -= 4;
    }

    private static IRecipe findRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        return null;
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_TEXTPAGE);
    }

    @Override
    public <T> void setGenericValue(T value) {
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        return null;
    }

    public static class Link {
        final int tab;
        final int y1;
        final int y2;
        final String node;

        public Link(int tab, int y1, int y2, String node) {
            this.tab = tab;
            this.y1 = y1;
            this.y2 = y2;
            this.node = node;
        }
    }

    public static class Page {
        final List<Line> lines = new ArrayList<Line>();

        public boolean isEmpty() {
            return this.lines.isEmpty();
        }

        public Line addLine(ModBase modBase, String line) {
            Line l = new Line(modBase, line);
            this.lines.add(l);
            return l;
        }
    }

    private static class Line {
        private boolean bold = false;
        private boolean islink = false;
        private boolean isnode;
        private boolean nexttab = false;
        String node = null;
        String line = null;
        IRecipe recipe = null;
        ResourceLocation resourceLocation = null;
        int u;
        int v;
        int height = 14;

        public boolean isBold() {
            return this.bold;
        }

        public boolean isLink() {
            return this.islink;
        }

        public boolean isNode() {
            return this.isnode;
        }

        public boolean isNexttab() {
            return this.nexttab;
        }

        Line(ModBase modBase, String line) {
            if (line.startsWith("{b}")) {
                this.bold = true;
                this.line = line.substring(3);
            } else if (line.startsWith("{/}")) {
                this.nexttab = true;
                this.height = 0;
            } else if (line.startsWith("{n:")) {
                this.parseNode(line);
            } else if (line.startsWith("{l:")) {
                this.parseLink(line);
            } else if (line.startsWith("{i:")) {
                this.parseImage(modBase, line);
            } else if (line.startsWith("{ri:")) {
                this.parseItemRecipe(modBase, line);
            } else if (line.startsWith("{rb:")) {
                this.parseBlockRecipe(modBase, line);
            } else {
                this.line = line;
            }
        }

        private void parseNode(String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                this.node = line.substring(3, end);
                this.isnode = true;
                this.line = null;
            }
            this.height = 0;
        }

        private void parseLink(String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                this.node = line.substring(3, end);
                this.islink = true;
                this.line = line.substring(end + 1);
            }
        }

        private void parseBlockRecipe(ModBase modBase, String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modBase.getModId(), line.substring(4, end)));
                IRecipe iRecipe = this.recipe = block == null ? null : TextPage.findRecipe(new ItemStack((IItemProvider)block));
                if (this.recipe == null) {
                    this.line = line;
                } else {
                    this.height = 62;
                }
            }
        }

        private void parseItemRecipe(ModBase modBase, String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modBase.getModId(), line.substring(4, end)));
                IRecipe iRecipe = this.recipe = item == null ? null : TextPage.findRecipe(new ItemStack((IItemProvider)item));
                if (this.recipe == null) {
                    this.line = line;
                } else {
                    this.height = 62;
                }
            }
        }

        private void parseImage(ModBase modBase, String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                String substring = line.substring(3, end);
                String[] split = StringUtils.split((String)substring, (char)',');
                this.u = 0;
                this.v = 0;
                if (split.length > 2) {
                    try {
                        this.u = Integer.parseInt(split[1]);
                        this.v = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.resourceLocation = new ResourceLocation(modBase.getModId(), split[0]);
                this.line = split.length > 3 ? split[3] : "<error>";
                this.height = 18;
            }
        }
    }
}

