/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mcjty.lib.crafting.CopyNBTRecipeBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class BaseRecipeProvider
extends RecipeProvider {
    private final Map<Character, Ingredient> defaultIngredients = new HashMap<Character, Ingredient>();
    private String group = "";

    protected BaseRecipeProvider group(String group) {
        this.group = group;
        return this;
    }

    protected BaseRecipeProvider add(char c, Tag<Item> itemTag) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.func_199805_a(itemTag));
        return this;
    }

    protected BaseRecipeProvider add(char c, IItemProvider itemProvider) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
        return this;
    }

    protected BaseRecipeProvider add(char c, Ingredient ingredient) {
        this.defaultIngredients.put(Character.valueOf(c), ingredient);
        return this;
    }

    private void buildIntern(Consumer<IFinishedRecipe> consumer, Consumer<String> lineConsumer, BiConsumer<Character, Ingredient> ingredientConsumer, String ... lines) {
        HashSet characters = new HashSet();
        for (String line : lines) {
            lineConsumer.accept(line);
            line.chars().forEach(value -> characters.add(Character.valueOf((char)value)));
        }
        for (Character c : characters) {
            if (!this.defaultIngredients.containsKey(c)) continue;
            ingredientConsumer.accept(c, this.defaultIngredients.get(c));
        }
    }

    protected void build(Consumer<IFinishedRecipe> consumer, CopyNBTRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, s -> builder.patternLine((String)s), (c, i) -> builder.key((Character)c, (Ingredient)i), lines);
        builder.setGroup(this.group).build(consumer);
    }

    protected void build(Consumer<IFinishedRecipe> consumer, ShapedRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, s -> builder.func_200472_a(s), (c, i) -> builder.func_200471_a(c, i), lines);
        builder.func_200473_b(this.group).func_200464_a(consumer);
    }

    protected void build(Consumer<IFinishedRecipe> consumer, ShapelessRecipeBuilder builder) {
        builder.func_200490_a(this.group).func_200482_a(consumer);
    }

    protected void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id, ShapelessRecipeBuilder builder) {
        builder.func_200490_a(this.group).func_200485_a(consumer, id);
    }

    protected void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id, CopyNBTRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, s -> builder.patternLine((String)s), (c, i) -> builder.key((Character)c, (Ingredient)i), lines);
        builder.setGroup(this.group).build(consumer, id);
    }

    protected void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id, ShapedRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, s -> builder.func_200472_a(s), (c, i) -> builder.func_200471_a(c, i), lines);
        builder.func_200473_b(this.group).func_200467_a(consumer, id);
    }

    public BaseRecipeProvider(DataGenerator datagen) {
        super(datagen);
        this.add('d', (IItemProvider)Items.field_151045_i);
        this.add('e', (IItemProvider)Items.field_151166_bC);
        this.add('o', (Tag<Item>)Tags.Items.ENDER_PEARLS);
        this.add('r', (IItemProvider)Items.field_151137_ax);
        this.add('R', (IItemProvider)Items.field_221858_em);
        this.add('i', (Tag<Item>)Tags.Items.INGOTS_IRON);
        this.add('p', (IItemProvider)Items.field_151121_aF);
        this.add('c', (Tag<Item>)ItemTags.field_219775_L);
        this.add('B', (IItemProvider)Blocks.field_196584_bK);
        this.add('W', (IItemProvider)Items.field_151131_as);
        this.add('L', (IItemProvider)Items.field_151129_at);
        this.add('b', (IItemProvider)Items.field_151133_ar);
        this.add('T', (IItemProvider)Items.field_221764_cr);
        this.add('D', (IItemProvider)Blocks.field_150346_d);
        this.add('G', (Tag<Item>)Tags.Items.GLASS);
        this.add('O', (IItemProvider)Blocks.field_150343_Z);
    }
}

