/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Iterator;
import javax.annotation.Nonnull;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class NoDirectionItemHander
implements IItemHandlerModifiable,
INBTSerializable<ListNBT> {
    private final InventoryHelper helper;
    private final GenericTileEntity te;

    protected void onUpdate(int index) {
        this.te.markDirtyQuick();
    }

    public NoDirectionItemHander(GenericTileEntity te, ContainerFactory factory) {
        this.helper = new InventoryHelper(te, factory, factory.getContainerSlots());
        this.te = te;
    }

    public int getSlots() {
        return this.helper.getCount();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.helper.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemInsertable(slot, stack)) {
            return stack;
        }
        ItemStack stackInSlot = this.helper.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.helper.setInventorySlotContents(copy.func_77976_d(), slot, copy);
                    this.onUpdate(slot);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.helper.setInventorySlotContents(copy.func_77976_d(), slot, copy);
                this.onUpdate(slot);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.helper.setInventorySlotContents(stack.func_77976_d(), slot, stack.func_77979_a(m));
                this.onUpdate(slot);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.helper.setInventorySlotContents(stack.func_77976_d(), slot, stack);
            this.onUpdate(slot);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.helper.getStackInSlot(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemExtractable(slot, stackInSlot)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.helper.decrStackSize(slot, m);
        this.onUpdate(slot);
        return decrStackSize;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.helper.setStackInSlot(slot, stack);
        this.onUpdate(slot);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public ContainerFactory getContainerFactory() {
        return this.helper.getContainerFactory();
    }

    public ListNBT serializeNBT() {
        ItemStackList list = this.helper.getStacks();
        ListNBT bufferTagList = new ListNBT();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            CompoundNBT compoundNBT = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(compoundNBT);
            }
            bufferTagList.add((Object)compoundNBT);
        }
        return bufferTagList;
    }

    public void deserializeNBT(ListNBT nbt) {
        ItemStackList list = this.helper.getStacks();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundNBT compoundNBT = nbt.func_150305_b(i);
            if (i >= list.size()) continue;
            list.set(i, ItemStack.func_199557_a((CompoundNBT)compoundNBT));
        }
    }
}

