/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryHelper {
    private final GenericTileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private ItemStackList stacks;
    private int count;

    public InventoryHelper(GenericTileEntity tileEntity, ContainerFactory containerFactory, int count) {
        this.tileEntity = tileEntity;
        this.containerFactory = containerFactory;
        this.stacks = ItemStackList.create(count);
        this.count = count;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public void setNewCount(int newcount) {
        this.count = newcount;
        ItemStackList newstacks = ItemStackList.create(newcount);
        for (int i = 0; i < Math.min(this.stacks.size(), newstacks.size()); ++i) {
            newstacks.set(i, this.stacks.get(i));
        }
        this.stacks = newstacks;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = (ItemStack)this.stacks.get(index);
        this.setStackInSlot(index, ItemStack.field_190927_a);
        return stack;
    }

    public static void handleSlot(TileEntity tileEntity, int slot, Consumer<ItemStack> consumer) {
        InventoryHelper.handleSlot(tileEntity, slot, -1, consumer);
    }

    public static void handleSlot(TileEntity tileEntity, int slot, int amount, Consumer<ItemStack> consumer) {
        if (tileEntity == null) {
            return;
        }
        int finalAmount = amount;
        tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            ItemStack item = handler.getStackInSlot(slot);
            if (!item.func_190926_b()) {
                ItemStack stack;
                int a = finalAmount;
                if (a == -1) {
                    a = item.func_190916_E();
                }
                if (!(stack = handler.extractItem(slot, a, false)).func_190926_b()) {
                    consumer.accept(stack);
                }
            }
        });
    }

    public static int getInventorySize(TileEntity tileEntity) {
        if (tileEntity == null) {
            return 0;
        }
        return (Integer)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse((Object)0);
    }

    public static boolean isInventory(TileEntity te) {
        return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    public static Stream<ItemStack> getItems(TileEntity tileEntity, Predicate<ItemStack> predicate) {
        Stream.Builder builder = Stream.builder();
        if (tileEntity != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack itemStack = handler.getStackInSlot(i);
                    if (itemStack.func_190926_b() || !predicate.test(itemStack)) continue;
                    builder.add(itemStack);
                }
            });
        }
        return builder.build();
    }

    public static boolean installModule(PlayerEntity player, ItemStack heldItem, Hand hand, BlockPos pos, int start, int stop) {
        World world = player.func_130014_f_();
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return (Boolean)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inventory -> {
            for (int i = start; i <= stop; ++i) {
                if (!inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemStack copy = heldItem.func_77946_l();
                copy.func_190920_e(1);
                if (!(inventory instanceof IItemHandlerModifiable)) {
                    throw new IllegalStateException("Not an IItemHandlerModifiable!");
                }
                ((IItemHandlerModifiable)inventory).setStackInSlot(i, copy);
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                if (world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Installed module"), false);
                }
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    @Nullable
    public static ItemStack insertItem(World world, BlockPos pos, Direction direction, ItemStack s) {
        TileEntity te = world.func_175625_s(direction == null ? pos : pos.func_177972_a(direction));
        if (te != null) {
            Direction opposite = direction == null ? null : direction.func_176734_d();
            return (ItemStack)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)s, (boolean)false)).orElse((Object)ItemStack.field_190927_a);
        }
        return s;
    }

    private static boolean insertItemsItemHandlerWithUndo(IItemHandler dest, List<ItemStack> stacks, boolean simulate) {
        if (dest == null || stacks == null || stacks.isEmpty()) {
            return true;
        }
        if (stacks.size() == 1) {
            ItemStack stack = stacks.get(0);
            stack = ItemHandlerHelper.insertItem((IItemHandler)dest, (ItemStack)stack, (boolean)simulate);
            return stack.func_190926_b();
        }
        List s = stacks.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        for (int i = 0; i < dest.getSlots(); ++i) {
            boolean empty = true;
            for (int j = 0; j < stacks.size(); ++j) {
                ItemStack stack = dest.insertItem(i, (ItemStack)s.get(j), simulate);
                if (!stack.func_190926_b()) {
                    empty = false;
                }
                s.set(j, stack);
            }
            if (!empty) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return !itemstack1.func_190926_b() && itemstack1.func_77973_b() == result.func_77973_b() && result.func_77952_i() == itemstack1.func_77952_i() && ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1);
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStackList getStacks() {
        return this.stacks;
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        this.stacks.set(index, stack);
    }

    public boolean containsItem(int index) {
        if (index >= this.stacks.size()) {
            return false;
        }
        return !((ItemStack)this.stacks.get(index)).func_190926_b();
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, ItemStack.field_190927_a);
            if (old.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            old.func_190920_e(0);
            return old;
        }
        if (!((ItemStack)this.stacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(index)).func_190916_E() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, ItemStack.field_190927_a);
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (((ItemStack)this.stacks.get(index)).func_190926_b()) {
                this.stacks.set(index, ItemStack.field_190927_a);
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return ItemStack.field_190927_a;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (this.containerFactory.isGhostSlot(index)) {
            if (!stack.func_190926_b()) {
                ItemStack stack1 = stack.func_77946_l();
                if (index < 9) {
                    stack1.func_190920_e(1);
                }
                this.stacks.set(index, stack1);
            } else {
                this.stacks.set(index, ItemStack.field_190927_a);
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            if (!stack.func_190926_b()) {
                this.stacks.set(index, stack.func_77946_l());
            } else {
                this.stacks.set(index, ItemStack.field_190927_a);
            }
        } else {
            this.stacks.set(index, stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > stackLimit) {
                if (stackLimit <= 0) {
                    stack.func_190920_e(0);
                } else {
                    stack.func_190920_e(stackLimit);
                }
            }
            this.tileEntity.func_70296_d();
        }
    }

    @Nonnull
    public static ItemStack insertItemRanged(IItemHandler dest, @Nonnull ItemStack stack, int start, int stop, boolean simulate) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = start; i < stop; ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

