/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.CraftingSlot;
import mcjty.lib.container.GenericCrafter;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GenericContainer
extends Container
implements IGenericContainer {
    protected Map<String, IItemHandler> inventories = new HashMap<String, IItemHandler>();
    private ContainerFactory factory;
    private GenericCrafter crafter = null;
    protected final BlockPos pos;
    protected final GenericTileEntity te;

    public GenericContainer(@Nullable ContainerType<?> type, int id, ContainerFactory factory, BlockPos pos, @Nullable GenericTileEntity te) {
        super(type, id);
        this.factory = factory;
        this.pos = pos;
        this.te = te;
        factory.doSetup();
    }

    @Override
    public Container getAsContainer() {
        return this;
    }

    public GenericTileEntity getTe() {
        return this.te;
    }

    @Override
    public void addShortListener(IntReferenceHolder holder) {
        this.func_216958_a(holder);
    }

    @Override
    public void addIntegerListener(final IntReferenceHolder holder) {
        this.func_216958_a(new IntReferenceHolder(){
            private int lastKnown;

            public int func_221495_b() {
                return holder.func_221495_b() & 0xFFFF;
            }

            public void func_221494_a(int val) {
                int full = holder.func_221495_b();
                holder.func_221494_a(full & 0xFFFF0000 | val & 0xFFFF);
            }

            public boolean func_221496_c() {
                int i = this.func_221495_b();
                boolean flag = i != this.lastKnown;
                this.lastKnown = i;
                return flag;
            }
        });
        this.func_216958_a(new IntReferenceHolder(){
            private int lastKnown;

            public int func_221495_b() {
                return holder.func_221495_b() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int val) {
                int full = holder.func_221495_b();
                holder.func_221494_a(full & 0xFFFF | (val & 0xFFFF) << 16);
            }

            public boolean func_221496_c() {
                int i = this.func_221495_b();
                boolean flag = i != this.lastKnown;
                this.lastKnown = i;
                return flag;
            }
        });
    }

    public void addInventory(String name, @Nullable IItemHandler inventory) {
        if (inventory != null) {
            this.inventories.put(name, inventory);
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IItemHandler getInventory(String name) {
        return this.inventories.get(name);
    }

    public boolean func_75145_c(PlayerEntity player) {
        for (IItemHandler iItemHandler : this.inventories.values()) {
        }
        return true;
    }

    public SlotType getSlotType(int index) {
        return this.factory.getSlotType(index);
    }

    public GenericCrafter getCrafter() {
        return this.crafter;
    }

    public void setCrafter(GenericCrafter crafter) {
        this.crafter = crafter;
    }

    @Override
    public void setupInventories(IItemHandler itemHandler, PlayerInventory inventory) {
        this.addInventory("container", itemHandler);
        this.addInventory("player", (IItemHandler)new InvWrapper((IInventory)inventory));
        this.generateSlots();
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : this.factory.getSlots()) {
            IItemHandler inventory = this.inventories.get(slotFactory.getInventoryName());
            int index = slotFactory.getIndex();
            int x = slotFactory.getX();
            int y = slotFactory.getY();
            SlotType slotType = slotFactory.getSlotType();
            Slot slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            this.func_75146_a(slot);
        }
    }

    protected Slot createSlot(SlotFactory slotFactory, IItemHandler inventory, int index, int x, int y, SlotType slotType) {
        SlotItemHandler slot;
        if (slotType == SlotType.SLOT_GHOST) {
            slot = new GhostSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_GHOSTOUT) {
            slot = new GhostOutputSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_SPECIFICITEM) {
            final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
            slot = new SlotItemHandler(inventory, index, x, y){

                public boolean func_75214_a(ItemStack stack) {
                    return slotDefinition.itemStackMatches(stack);
                }
            };
        } else {
            slot = slotType == SlotType.SLOT_CRAFTRESULT ? new CraftingSlot(inventory, this.te, index, x, y, this.crafter) : new BaseSlot(inventory, this.te, index, x, y);
        }
        return slot;
    }

    private boolean mergeItemStacks(ItemStack itemStack, int sourceSlot, SlotType slotType, boolean reverse) {
        if (slotType == SlotType.SLOT_SPECIFICITEM) {
            for (SlotDefinition definition : this.factory.getSlotRangesMap().keySet()) {
                if (!slotType.equals((Object)definition.getType()) || !this.mergeItemStacks(itemStack, sourceSlot, definition, reverse)) continue;
                return true;
            }
            return false;
        }
        return this.mergeItemStacks(itemStack, sourceSlot, new SlotDefinition(slotType, new ItemStack[0]), reverse);
    }

    protected boolean mergeItemStacks(ItemStack itemStack, int sourceSlot, SlotDefinition slotDefinition, boolean reverse) {
        SlotRanges ranges = this.factory.getSlotRangesMap().get(slotDefinition);
        if (ranges == null) {
            return false;
        }
        SlotType slotType = slotDefinition.getType();
        if (itemStack.func_77973_b() != null && slotType == SlotType.SLOT_SPECIFICITEM && !slotDefinition.itemStackMatches(itemStack)) {
            return false;
        }
        for (Range<Integer> r : ranges.asRanges()) {
            Integer start = (Integer)r.lowerEndpoint();
            int end = (Integer)r.upperEndpoint();
            if (!this.func_75135_a(itemStack, start, end, reverse)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            itemstack = origStack.func_77946_l();
            if (this.factory.isSpecificItemSlot(index)) {
                if (!this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERINV, true) && !this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERHOTBAR, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(origStack, itemstack);
            } else if (this.factory.isOutputSlot(index) || this.factory.isInputSlot(index) || this.factory.isContainerSlot(index)) {
                if (!(this.mergeItemStacks(origStack, index, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERINV, true) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERHOTBAR, false))) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(origStack, itemstack);
            } else {
                if (this.factory.isGhostSlot(index) || this.factory.isGhostOutputSlot(index)) {
                    return ItemStack.field_190927_a;
                }
                if (this.factory.isPlayerInventorySlot(index)) {
                    if (!(this.mergeItemStacks(origStack, index, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_INPUT, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERHOTBAR, false))) {
                        return ItemStack.field_190927_a;
                    }
                } else if (this.factory.isPlayerHotbarSlot(index)) {
                    if (!(this.mergeItemStacks(origStack, index, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_INPUT, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERINV, false))) {
                        return ItemStack.field_190927_a;
                    }
                } else {
                    Logging.log("Weird slot at index: " + index);
                }
            }
            if (origStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (origStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, origStack);
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reverseOrder) {
        int amount;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reverseOrder) {
            checkIndex = toIndex - 1;
        }
        ItemStack itemstack1 = ItemStack.field_190927_a;
        if (par1ItemStack.func_77985_e()) {
            while (!par1ItemStack.func_190926_b() && (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && par1ItemStack.func_77952_i() == itemstack1.func_77952_i() && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack)) {
                    int maxStackSize;
                    int mergedSize = itemstack1.func_190916_E() + par1ItemStack.func_190916_E();
                    if (mergedSize <= (maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a()))) {
                        par1ItemStack.func_190920_e(0);
                        if (mergedSize <= 0) {
                            itemstack1.func_190920_e(0);
                        } else {
                            itemstack1.func_190920_e(mergedSize);
                        }
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.func_190916_E() < maxStackSize) {
                        amount = -(maxStackSize - itemstack1.func_190916_E());
                        par1ItemStack.func_190917_f(amount);
                        if (maxStackSize <= 0) {
                            itemstack1.func_190920_e(0);
                        } else {
                            itemstack1.func_190920_e(maxStackSize);
                        }
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (!par1ItemStack.func_190926_b()) {
            checkIndex = reverseOrder ? toIndex - 1 : fromIndex;
            while (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1.func_190926_b() && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    int amount1 = Math.min(in.func_190916_E(), slot.func_75219_a());
                    if (amount1 <= 0) {
                        in.func_190920_e(0);
                    } else {
                        in.func_190920_e(amount1);
                    }
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    if (in.func_190916_E() >= par1ItemStack.func_190916_E()) {
                        par1ItemStack.func_190920_e(0);
                    } else {
                        amount = -in.func_190916_E();
                        par1ItemStack.func_190917_f(amount);
                    }
                    result = true;
                    break;
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    public ItemStack func_184996_a(int index, int button, ClickType mode, PlayerEntity player) {
        if (this.factory.isGhostSlot(index)) {
            ItemStack clickedWith;
            Slot slot = this.func_75139_a(index);
            if (slot.func_75216_d()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            if (!(clickedWith = player.field_71071_by.func_70445_o()).func_190926_b()) {
                ItemStack copy = clickedWith.func_77946_l();
                copy.func_190920_e(1);
                slot.func_75215_d(copy);
            }
            this.func_75142_b();
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(index, button, mode, player);
    }

    public static ContainerType<Container> createContainerType(String registryName) {
        ContainerType containerType = IForgeContainerType.create((windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(pos);
            if (te == null) {
                throw new IllegalStateException("Something went wrong getting the GUI");
            }
            return (Container)te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> h.createMenu(windowId, inv, McJtyLib.proxy.getClientPlayer())).orElseThrow(RuntimeException::new);
        });
        containerType.setRegistryName(registryName);
        return containerType;
    }

    public static <T extends Container> ContainerType<T> createContainerType() {
        ContainerType containerType = IForgeContainerType.create((windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(pos);
            if (te == null) {
                throw new IllegalStateException("Something went wrong getting the GUI");
            }
            return (Container)te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> h.createMenu(windowId, inv, McJtyLib.proxy.getClientPlayer())).orElseThrow(RuntimeException::new);
        });
        return containerType;
    }
}

