/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.compat.theoneprobe;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.setup.Registration;
import mcjty.lib.varia.Logging;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import org.apache.commons.lang3.text.WordUtils;

public class TOPCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new GetTheOneProbe());
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Override
        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            Logging.log("Enabled support for The One Probe");
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "mcjtylib:default";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
                    TOPInfoProvider provider;
                    TOPDriver driver;
                    if (blockState.func_177230_c() instanceof TOPInfoProvider && (driver = (provider = (TOPInfoProvider)blockState.func_177230_c()).getProbeDriver()) != null) {
                        driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
                    }
                }
            });
            probe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
                Block block = blockState.func_177230_c();
                if (block == Registration.MULTIPART_BLOCK) {
                    String modid = "mcjtylib";
                    ItemStack pickBlock = data.getPickBlock();
                    MultipartTE.Part part = MultipartBlock.getHitPart(blockState, (IBlockReader)world, data.getPos(), MultipartHelper.getPlayerEyes(player), data.getHitVec());
                    if (part != null) {
                        pickBlock = part.getState().func_177230_c().func_185473_a((IBlockReader)world, data.getPos(), part.getState());
                        modid = part.getState().func_177230_c().getRegistryName().func_110624_b();
                    }
                    modid = WordUtils.capitalize((String)modid);
                    if (!pickBlock.func_190926_b()) {
                        probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(TextStyleClass.MODNAME + modid);
                    } else {
                        probeInfo.vertical().text(TextStyleClass.NAME + "{*" + block.func_149739_a() + ".name" + "*}").text(TextStyleClass.MODNAME + modid);
                    }
                    return true;
                }
                return false;
            });
            McJtyLib.forEachMod(ModBase::handleTopExtras);
            return null;
        }
    }
}

