/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;

public class TileAnimatedTorch
extends TileMod
implements ITickableTileEntity {
    @ObjectHolder(value="botania:animated_torch")
    public static TileEntityType<TileAnimatedTorch> TYPE;
    private static final String TAG_SIDE = "side";
    private static final String TAG_ROTATING = "rotating";
    private static final String TAG_ROTATION_TICKS = "rotationTicks";
    private static final String TAG_ANGLE_PER_TICK = "anglePerTick";
    private static final String TAG_TORCH_MODE = "torchMode";
    private static final String TAG_NEXT_RANDOM_ROTATION = "nextRandomRotation";
    public static final Direction[] SIDES;
    public int side;
    public double rotation;
    public boolean rotating;
    public double lastTickRotation;
    public int nextRandomRotation;
    public int currentRandomRotation;
    private int rotationTicks;
    public double anglePerTick;
    private TorchMode torchMode = TorchMode.TOGGLE;

    public TileAnimatedTorch() {
        super(TYPE);
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.nextRandomRotation = this.field_145850_b.field_73012_v.nextInt(4);
        }
    }

    public void handRotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.animatedTorch, 0, (this.side + 1) % 4);
        }
    }

    public void onPlace(@Nullable LivingEntity entity) {
        if (entity != null) {
            this.side = Arrays.asList(SIDES).indexOf(entity.func_174811_aO().func_176734_d());
        }
        this.field_145850_b.func_195593_d(this.func_174877_v().func_177972_a(SIDES[this.side].func_176734_d()), this.func_195044_w().func_177230_c());
    }

    public void toggle() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.animatedTorch, 0, this.torchMode.modeSwitcher.rotate(this, this.side));
            this.nextRandomRotation = this.field_145850_b.field_73012_v.nextInt(4);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public void onWanded() {
        int modeOrdinal = this.torchMode.ordinal();
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[(modeOrdinal + 1) % modes.length];
    }

    public boolean func_145842_c(int id, int param) {
        if (id == 0) {
            this.rotateTo(param);
            return true;
        }
        return super.func_145842_c(id, param);
    }

    private void rotateTo(int side) {
        if (this.rotating) {
            return;
        }
        this.currentRandomRotation = this.nextRandomRotation;
        int finalRotation = side * 90;
        double diff = ((double)finalRotation - this.rotation % 360.0) % 360.0;
        if (diff < 0.0) {
            diff = 360.0 + diff;
        }
        this.rotationTicks = 4;
        this.anglePerTick = diff / (double)this.rotationTicks;
        this.side = side;
        this.rotating = true;
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        for (Direction e : Direction.values()) {
            this.field_145850_b.func_195593_d(this.func_174877_v().func_177972_a(e), this.func_195044_w().func_177230_c());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc) {
        int x = mc.func_228018_at_().func_198107_o() / 2 + 10;
        int y = mc.func_228018_at_().func_198087_p() / 2 - 8;
        mc.func_175599_af().func_180450_b(new ItemStack((IItemProvider)Blocks.field_150429_aA), x, y);
        mc.field_71466_p.func_175063_a(I18n.func_135052_a((String)("botania.animatedTorch." + this.torchMode.name().toLowerCase()), (Object[])new Object[0]), (float)(x + 18), (float)(y + 6), 0xFF4444);
    }

    public void func_73660_a() {
        if (this.rotating) {
            this.lastTickRotation = this.rotation;
            this.rotation = (this.rotation + this.anglePerTick) % 360.0;
            --this.rotationTicks;
            if (this.rotationTicks <= 0) {
                this.rotating = false;
                this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
                for (Direction e : Direction.values()) {
                    this.field_145850_b.func_195593_d(this.func_174877_v().func_177972_a(e), this.func_195044_w().func_177230_c());
                }
            }
        } else {
            this.rotation = this.side * 90;
        }
        if (this.field_145850_b.field_72995_K) {
            int amt = this.rotating ? 3 : (Math.random() < 0.1 ? 1 : 0);
            double x = (double)this.func_174877_v().func_177958_n() + 0.5 + Math.cos((this.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            double y = (double)this.func_174877_v().func_177956_o() + 0.2;
            double z = (double)this.func_174877_v().func_177952_p() + 0.5 + Math.sin((this.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            for (int i = 0; i < amt; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_SIDE, this.side);
        cmp.func_74757_a(TAG_ROTATING, this.rotating);
        cmp.func_74768_a(TAG_ROTATION_TICKS, this.rotationTicks);
        cmp.func_74780_a(TAG_ANGLE_PER_TICK, this.anglePerTick);
        cmp.func_74768_a(TAG_TORCH_MODE, this.torchMode.ordinal());
        cmp.func_74768_a(TAG_NEXT_RANDOM_ROTATION, this.nextRandomRotation);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.side = cmp.func_74762_e(TAG_SIDE);
        this.rotating = cmp.func_74767_n(TAG_ROTATING);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.rotationTicks = cmp.func_74762_e(TAG_ROTATION_TICKS);
        }
        this.anglePerTick = cmp.func_74769_h(TAG_ANGLE_PER_TICK);
        this.nextRandomRotation = cmp.func_74762_e(TAG_NEXT_RANDOM_ROTATION);
        int modeOrdinal = cmp.func_74762_e(TAG_TORCH_MODE);
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[modeOrdinal % modes.length];
    }

    static {
        SIDES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    }

    public static enum TorchMode {
        TOGGLE((t, i) -> (i + 2) % 4),
        ROTATE((t, i) -> (i + 1) % 4),
        RANDOM((t, i) -> t.currentRandomRotation);

        public final RotationHandler modeSwitcher;

        private TorchMode(RotationHandler modeSwitcher) {
            this.modeSwitcher = modeSwitcher;
        }

        private static interface RotationHandler {
            public int rotate(TileAnimatedTorch var1, int var2);
        }
    }
}

