/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.brew;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Brew
extends ForgeRegistryEntry<Brew> {
    private final int color;
    private final int cost;
    private final List<EffectInstance> effects;
    private boolean canInfuseBloodPendant = true;
    private boolean canInfuseIncense = true;

    public Brew(int color, int cost, EffectInstance ... effects) {
        this.color = color;
        this.cost = cost;
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    public Brew setNotBloodPendantInfusable() {
        this.canInfuseBloodPendant = false;
        return this;
    }

    public Brew setNotIncenseInfusable() {
        this.canInfuseIncense = false;
        return this;
    }

    public boolean canInfuseBloodPendant() {
        return this.canInfuseBloodPendant;
    }

    public boolean canInfuseIncense() {
        return this.canInfuseIncense;
    }

    public String getTranslationKey() {
        return String.format("%s.brew.%s", this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a());
    }

    public String getTranslationKey(ItemStack stack) {
        return this.getTranslationKey();
    }

    public int getColor(ItemStack stack) {
        return this.color;
    }

    public int getManaCost() {
        return this.cost;
    }

    public int getManaCost(ItemStack stack) {
        return this.getManaCost();
    }

    public List<EffectInstance> getPotionEffects(ItemStack stack) {
        return this.effects;
    }
}

