/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.container.AddFilterContainer;
import net.blay09.mods.refinedrelocation.container.BlockExtenderContainer;
import net.blay09.mods.refinedrelocation.container.ChecklistFilterContainer;
import net.blay09.mods.refinedrelocation.container.ContainerFastHopper;
import net.blay09.mods.refinedrelocation.container.IRootFilterContainer;
import net.blay09.mods.refinedrelocation.container.NameFilterContainer;
import net.blay09.mods.refinedrelocation.container.RootFilterContainer;
import net.blay09.mods.refinedrelocation.container.SortingChestContainer;
import net.blay09.mods.refinedrelocation.filter.NameFilter;
import net.blay09.mods.refinedrelocation.tile.FastHopperTileEntity;
import net.blay09.mods.refinedrelocation.tile.SortingChestTileEntity;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;

public class ModContainers {
    public static ContainerType<BlockExtenderContainer> blockExtender;
    public static ContainerType<ContainerFastHopper> fastHopper;
    public static ContainerType<SortingChestContainer> sortingChest;
    public static ContainerType<AddFilterContainer> addFilter;
    public static ContainerType<RootFilterContainer> rootFilter;
    public static ContainerType<NameFilterContainer> nameFilter;
    public static ContainerType<ChecklistFilterContainer> checklistFilter;

    public static void register(IForgeRegistry<ContainerType<?>> registry) {
        addFilter = ModContainers.register("add_filter", (windowId, inv, data) -> {
            TileEntity tileEntity;
            BlockPos pos = data.func_179259_c();
            byte rootFilterIndex = 0;
            if (data.readableBytes() > 0) {
                rootFilterIndex = data.readByte();
            }
            if ((tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos)) != null) {
                return new AddFilterContainer(windowId, inv, tileEntity, rootFilterIndex);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(addFilter);
        blockExtender = ModContainers.register("block_extender", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof TileBlockExtender) {
                return new BlockExtenderContainer(windowId, inv, (TileBlockExtender)tileEntity);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(blockExtender);
        sortingChest = ModContainers.register("sorting_chest", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof SortingChestTileEntity) {
                return new SortingChestContainer(windowId, inv, (SortingChestTileEntity)tileEntity);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(sortingChest);
        fastHopper = ModContainers.register("fast_hopper", (windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof FastHopperTileEntity) {
                return new ContainerFastHopper(windowId, inv, (FastHopperTileEntity)tileEntity);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(fastHopper);
        rootFilter = ModContainers.register("root_filter", (windowId, inv, data) -> {
            TileEntity tileEntity;
            BlockPos pos = data.func_179259_c();
            byte rootFilterIndex = 0;
            if (data.readableBytes() > 0) {
                rootFilterIndex = data.readByte();
            }
            if ((tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos)) != null) {
                return new RootFilterContainer(windowId, inv, tileEntity, rootFilterIndex);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(rootFilter);
        nameFilter = ModContainers.register("name_filter", (windowId, inv, data) -> {
            IFilter filter;
            Container container;
            BlockPos pos = data.func_179259_c();
            byte rootFilterIndex = data.readByte();
            byte filterIndex = data.readByte();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity != null && (container = inv.field_70458_d.field_71070_bA) instanceof IRootFilterContainer && (filter = ((IRootFilterContainer)container).getRootFilter().getFilter(filterIndex)) != null) {
                return new NameFilterContainer(windowId, inv, tileEntity, rootFilterIndex, (NameFilter)filter);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(nameFilter);
        checklistFilter = ModContainers.register("checklist_filter", (windowId, inv, data) -> {
            IFilter filter;
            Container container;
            BlockPos pos = data.func_179259_c();
            byte rootFilterIndex = data.readByte();
            byte filterIndex = data.readByte();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity != null && (container = inv.field_70458_d.field_71070_bA) instanceof IRootFilterContainer && (filter = ((IRootFilterContainer)container).getRootFilter().getFilter(filterIndex)) != null) {
                return new ChecklistFilterContainer(windowId, inv, tileEntity, rootFilterIndex, (IChecklistFilter)filter);
            }
            throw new RuntimeException("Could not open container screen");
        });
        registry.register(checklistFilter);
    }

    private static <T extends Container> ContainerType<T> register(String name, IContainerFactory<T> containerFactory) {
        return (ContainerType)new ContainerType(containerFactory).setRegistryName(name);
    }
}

