/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.tile.IDroppableItemHandler;
import net.blay09.mods.refinedrelocation.util.ItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RefinedRelocationUtils {
    public static LazyOptional<IRootFilter> getRootFilter(TileEntity tileEntity, int rootFilterIndex) {
        LazyOptional foundRootFilter = tileEntity.getCapability(Capabilities.MULTI_ROOT_FILTER).map(it -> it.getRootFilter(rootFilterIndex));
        if (foundRootFilter.isPresent()) {
            return foundRootFilter;
        }
        return rootFilterIndex == 0 ? tileEntity.getCapability(Capabilities.ROOT_FILTER) : LazyOptional.empty();
    }

    public static void dropItemHandler(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity instanceof IDroppableItemHandler) {
                ((IDroppableItemHandler)tileEntity).getDroppedItemHandlers().forEach(itemHandler -> ItemUtils.dropItemHandlerItems(world, pos, itemHandler));
            } else {
                LazyOptional itemHandlerCap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                itemHandlerCap.ifPresent(itemHandler -> ItemUtils.dropItemHandlerItems(world, pos, itemHandler));
            }
        }
    }

    @Nullable
    public static <T> T orNull(LazyOptional<T> optional) {
        return (T)optional.orElse(null);
    }

    public static int getComparatorInputOverride(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional itemHandlerCap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            return (Integer)itemHandlerCap.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse((Object)0);
        }
        return 0;
    }
}

