/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.client;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.GuiTools;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.craftinggrid.GuiCraftingGrid;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.network.PacketGetInventoryInfo;
import mcjty.rftoolsstorage.modules.scanner.network.PacketRequestItem;
import mcjty.rftoolsstorage.modules.scanner.network.PacketReturnInventoryInfo;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiStorageScanner
extends GenericGuiContainer<StorageScannerTileEntity, StorageScannerContainer> {
    private static final int STORAGE_MONITOR_WIDTH = 256;
    private static final int STORAGE_MONITOR_HEIGHT = 244;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsstorage", "textures/gui/storagescanner.png");
    private static final ResourceLocation guielements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private WidgetList storageList;
    private WidgetList itemList;
    private ToggleButton openViewButton;
    private EnergyBar energyBar;
    private Button topButton;
    private Button upButton;
    private Button downButton;
    private Button bottomButton;
    private Button removeButton;
    private TextField searchField;
    private ImageChoiceLabel exportToStarred;
    private Panel storagePanel;
    private Panel itemPanel;
    private ScrollableLabel radiusLabel;
    private Label visibleRadiusLabel;
    private GuiCraftingGrid craftingGrid = new GuiCraftingGrid();
    private long prevTime = -1L;
    private int listDirty = 0;
    private boolean init = false;
    public static List<PacketReturnInventoryInfo.InventoryInfo> fromServer_inventories = new ArrayList<PacketReturnInventoryInfo.InventoryInfo>();
    public static Set<BlockPos> fromServer_foundInventories = new HashSet<BlockPos>();
    public static List<ItemStack> fromServer_inventory = new ArrayList<ItemStack>();
    public static List<ItemStack> fromServer_craftable = new ArrayList<ItemStack>();
    private static long lastTime = 0L;

    public GuiStorageScanner(StorageScannerTileEntity te, StorageScannerContainer container, PlayerInventory playerInventory) {
        super((ModBase)RFToolsStorage.instance, (GenericTileEntity)te, (Container)container, playerInventory, 0, "stomon");
        this.field_146999_f = 256;
        this.field_147000_g = 244;
    }

    public void init() {
        super.init();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.minecraft, (Screen)this).setFilledRectThickness(1)).setVertical().setDesiredWidth(10)).setDesiredHeight(50)).setShowText(false);
        this.openViewButton = (ToggleButton)((ToggleButton)new ToggleButton(this.minecraft, (Screen)this).setCheckMarker(false).setText("V")).setTooltips(new String[]{"Toggle wide storage list"});
        this.openViewButton.setPressed(((StorageScannerTileEntity)this.tileEntity).isOpenWideView());
        this.openViewButton.addButtonEvent(widget -> this.toggleView());
        this.upButton = (Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("up")).setText("U")).setTooltips(new String[]{"Move inventory up"});
        this.topButton = (Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("top")).setText("T")).setTooltips(new String[]{"Move inventory to the top"});
        this.downButton = (Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("down")).setText("D")).setTooltips(new String[]{"Move inventory down"});
        this.bottomButton = (Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("bottom")).setText("B")).setTooltips(new String[]{"Move inventory to the bottom"});
        this.removeButton = (Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("remove")).setText("R")).setTooltips(new String[]{"Remove inventory from list"});
        Panel energyPanel = (Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(0)).setSpacing(1)).setDesiredWidth(10);
        ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)energyPanel.addChild((Widget)this.openViewButton)).addChild((Widget)this.energyBar)).addChild((Widget)this.topButton)).addChild((Widget)this.upButton)).addChild((Widget)this.downButton)).addChild((Widget)this.bottomButton)).addChild((Widget)new Label(this.minecraft, (Screen)this).setText(" "))).addChild((Widget)this.removeButton);
        this.exportToStarred = (ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.minecraft, (Screen)this).setName("export")).setLayoutHint(12, 223, 13, 13);
        this.exportToStarred.addChoice("No", "Export to current container", guielements, 131, 19);
        this.exportToStarred.addChoice("Yes", "Export to first routable container", guielements, 115, 19);
        this.storagePanel = this.makeStoragePanel(energyPanel);
        this.itemPanel = this.makeItemPanel();
        Button scanButton = (Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("scan")).setText("Scan")).setDesiredWidth(50)).setDesiredHeight(14);
        if (RFToolsStorage.setup.xnet) {
            if (((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue()) {
                scanButton.setTooltips(new String[]{"Do a scan of all", "storage units connected", "with an active XNet channel"});
            } else {
                scanButton.setTooltips(new String[]{"Do a scan of all", "storage units in radius", "Use 'xnet' radius to", "restrict to XNet only"});
            }
        } else {
            scanButton.setTooltips(new String[]{"Do a scan of all", "storage units in radius"});
        }
        this.radiusLabel = ((ScrollableLabel)((ScrollableLabel)((ScrollableLabel)new ScrollableLabel(this.minecraft, (Screen)this).setLayoutHint(1, 1, 1, 1)).setName("radius")).setVisible(false)).setRealMinimum(RFToolsStorage.setup.xnet ? 0 : 1).setRealMaximum(20);
        this.visibleRadiusLabel = new Label(this.minecraft, (Screen)this);
        this.visibleRadiusLabel.setDesiredWidth(40);
        this.searchField = new TextField(this.minecraft, (Screen)this).addTextEvent((parent, newText) -> {
            this.storageList.clearHilightedRows();
            fromServer_foundInventories.clear();
            this.startSearch(newText);
        });
        Panel searchPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 142, 245, 18))).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(18)).addChild((Widget)new Label(this.minecraft, (Screen)this).setText("Search:"))).addChild((Widget)this.searchField);
        Slider radiusSlider = ((Slider)((Slider)new Slider(this.minecraft, (Screen)this).setHorizontal().setTooltips(new String[]{"Radius of scan"})).setMinimumKnobSize(12).setDesiredHeight(14)).setScrollableName("radius");
        Panel scanPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayoutHint(8, 162, 74, 54)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(6)).setSpacing(1)).addChild((Widget)scanButton);
        if (!RFToolsStorage.setup.xnet || !((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue()) {
            scanPanel.addChild((Widget)radiusSlider);
        }
        scanPanel.addChildren(new Widget[]{this.visibleRadiusLabel, this.radiusLabel});
        if (((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            scanButton.setEnabled(false);
            radiusSlider.setVisible(false);
        }
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.storagePanel)).addChild((Widget)this.itemPanel)).addChild((Widget)searchPanel)).addChild((Widget)scanPanel)).addChild((Widget)this.exportToStarred);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.bind(RFToolsStorageMessages.INSTANCE, "export", this.tileEntity, StorageScannerTileEntity.VALUE_EXPORT.getName());
        this.window.bind(RFToolsStorageMessages.INSTANCE, "radius", this.tileEntity, StorageScannerTileEntity.VALUE_RADIUS.getName());
        this.window.event("up", (source, params) -> this.moveUp());
        this.window.event("top", (source, params) -> this.moveTop());
        this.window.event("down", (source, params) -> this.moveDown());
        this.window.event("bottom", (source, params) -> this.moveBottom());
        this.window.event("remove", (source, params) -> this.removeFromList());
        this.window.event("scan", (source, params) -> RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketGetInventoryInfo(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), true)));
        this.minecraft.field_195559_v.func_197967_a(true);
        fromServer_foundInventories.clear();
        fromServer_inventory.clear();
        fromServer_craftable.clear();
        if (((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            fromServer_inventories.clear();
        }
        BlockPos pos = ((StorageScannerTileEntity)this.tileEntity).getCraftingGridContainerPos();
        this.craftingGrid.initGui(this.modBase, RFToolsStorageMessages.INSTANCE, this.minecraft, this, pos, ((StorageScannerTileEntity)this.tileEntity).getCraftingGridProvider(), this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).build());
        if (((Boolean)StorageScannerConfiguration.hilightStarredOnGuiOpen.get()).booleanValue()) {
            this.storageList.setSelected(0);
        }
        this.init = true;
    }

    private int getStoragePanelWidth() {
        return this.openViewButton.isPressed() ? 130 : 50;
    }

    private Panel makeItemPanel() {
        this.itemList = ((WidgetList)new WidgetList(this.minecraft, (Screen)this).setName("items")).setPropagateEventsToChildren(true).setInvisibleSelection(true);
        Slider itemListSlider = ((Slider)new Slider(this.minecraft, (Screen)this).setDesiredWidth(10)).setVertical().setScrollableName("items");
        return (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.getStoragePanelWidth() + 6, 4, 256 - this.getStoragePanelWidth() - 12, 140))).addChild((Widget)this.itemList)).addChild((Widget)itemListSlider);
    }

    private Panel makeStoragePanel(Panel energyPanel) {
        this.storageList = ((WidgetList)new WidgetList(this.minecraft, (Screen)this).setName("storage")).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget<?> parent, int index) {
                GuiStorageScanner.this.getInventoryOnServer();
            }

            public void doubleClick(Widget<?> parent, int index) {
                GuiStorageScanner.this.hilightSelectedContainer(index);
            }
        }).setPropagateEventsToChildren(true);
        Slider storageListSlider = ((Slider)new Slider(this.minecraft, (Screen)this).setDesiredWidth(10)).setVertical().setScrollableName("storage");
        return (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 4, this.getStoragePanelWidth(), 140))).setDesiredHeight(140)).addChild((Widget)energyPanel)).addChild((Widget)this.storageList)).addChild((Widget)storageListSlider);
    }

    private void toggleView() {
        this.storagePanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 4, this.getStoragePanelWidth(), 140));
        this.itemPanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.getStoragePanelWidth() + 6, 4, 256 - this.getStoragePanelWidth() - 12, 140));
        this.window.getToplevel().setBounds(this.window.getToplevel().getBounds());
        this.listDirty = 0;
        this.requestListsIfNeeded();
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.setView", TypedMap.builder().put(StorageScannerTileEntity.PARAM_VIEW, (Object)this.openViewButton.isPressed()).build());
    }

    public boolean mouseClicked(double x, double y, int button) {
        Slot slot;
        boolean r = super.mouseClicked(x, y, button);
        this.craftingGrid.getWindow().mouseClicked((int)x, (int)y, button);
        if (button == 1 && (slot = this.func_195360_a(x, y)) instanceof GhostOutputSlot) {
            this.window.sendAction(RFToolsStorageMessages.INSTANCE, this.tileEntity, "clearGrid");
        }
        return r;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        this.craftingGrid.getWindow().handleMouseInput(button);
        return super.mouseDragged(x, y, button, scaledX, scaledY);
    }

    public boolean mouseReleased(double x, double y, int state) {
        boolean rc = super.mouseReleased(x, y, state);
        this.craftingGrid.getWindow().mouseMovedOrUp((int)x, (int)y, state);
        return rc;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean rc = super.keyPressed(keyCode, scanCode, modifiers);
        this.craftingGrid.getWindow().keyTyped(keyCode, keyCode);
        return rc;
    }

    private void moveUp() {
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.up", TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.setSelected(this.storageList.getSelected() - 1);
        this.listDirty = 0;
    }

    private void moveTop() {
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.top", TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.setSelected(1);
        this.listDirty = 0;
    }

    private void moveDown() {
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.down", TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.setSelected(this.storageList.getSelected() + 1);
        this.listDirty = 0;
    }

    private void moveBottom() {
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.bottom", TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.setSelected(this.storageList.getChildCount() - 1);
        this.listDirty = 0;
    }

    private void removeFromList() {
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.remove", TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.listDirty = 0;
    }

    private void hilightSelectedContainer(int index) {
        if (index == -1) {
            return;
        }
        if (index == 0) {
            return;
        }
        PacketReturnInventoryInfo.InventoryInfo c = fromServer_inventories.get(index - 1);
        if (c != null) {
            Logging.message((PlayerEntity)this.minecraft.field_71439_g, (String)"The inventory is now highlighted");
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    private void startSearch(String text) {
        if (!text.isEmpty()) {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "scannerSearch", TypedMap.builder().put(CommandHandler.PARAM_SCANNER_DIM, (Object)((StorageScannerTileEntity)this.tileEntity).getDimension().func_186068_a()).put(CommandHandler.PARAM_SCANNER_POS, (Object)((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos()).put(CommandHandler.PARAM_SEARCH_TEXT, (Object)text).build());
        }
    }

    private void getInventoryOnServer() {
        BlockPos c = this.getSelectedContainerPos();
        if (c != null) {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "requestScannerContents", TypedMap.builder().put(CommandHandler.PARAM_SCANNER_DIM, (Object)((StorageScannerTileEntity)this.tileEntity).getDimension().func_186068_a()).put(CommandHandler.PARAM_SCANNER_POS, (Object)((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos()).put(CommandHandler.PARAM_INV_POS, (Object)c).build());
        }
    }

    private BlockPos getSelectedContainerPos() {
        int selected = this.storageList.getSelected();
        if (selected != -1) {
            if (selected == 0) {
                return new BlockPos(-1, -1, -1);
            }
            if (--selected < fromServer_inventories.size()) {
                PacketReturnInventoryInfo.InventoryInfo info = fromServer_inventories.get(selected);
                if (info == null) {
                    return null;
                }
                return info.getPos();
            }
        }
        return null;
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketGetInventoryInfo(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), false));
            this.getInventoryOnServer();
            this.listDirty = 20;
        }
    }

    private void updateContentsList() {
        this.itemList.removeChildren();
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        int numcolumns = this.openViewButton.isPressed() ? 5 : 9;
        int spacing = 3;
        Collections.sort(fromServer_inventory, Comparator.comparing(itemStack -> itemStack.func_200301_q().func_150254_d()));
        Collections.sort(fromServer_craftable, Comparator.comparing(itemStack -> itemStack.func_200301_q().func_150254_d()));
        String filterText = this.searchField.getText().toLowerCase();
        Predicate<ItemStack> matcher = StorageScannerTileEntity.getMatcher(filterText);
        for (ItemStack item : fromServer_inventory) {
            if (!filterText.isEmpty() && !matcher.test(item)) continue;
            currentPos = this.addItemToList(item, this.itemList, currentPos, numcolumns, spacing, false);
        }
        for (ItemStack item : fromServer_craftable) {
            if (!filterText.isEmpty() && !matcher.test(item)) continue;
            currentPos = this.addItemToList(item, this.itemList, currentPos, numcolumns, spacing, true);
        }
    }

    private Pair<Panel, Integer> addItemToList(ItemStack item, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int spacing, final boolean craftable) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns) {
            panel = (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(spacing)).setHorizontalMargin(1)).setDesiredHeight(12)).setUserObject((Object)new Integer(-1))).setDesiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.addChild((Widget)panel);
        }
        BlockRender blockRender = ((BlockRender)new BlockRender(this.minecraft, (Screen)this).setRenderItem((Object)item).setUserObject((Object)1)).setOffsetX(-1).setOffsetY(-1).setHilightOnHover(true);
        if (craftable) {
            blockRender.setFilledBackground(-5592576);
        }
        blockRender.addSelectionEvent(new BlockRenderEvent(){

            public void select(Widget<?> widget) {
                BlockRender br = (BlockRender)widget;
                Object item = br.getRenderItem();
                if (item != null) {
                    boolean shift = McJtyLib.proxy.isShiftKeyDown();
                    GuiStorageScanner.this.requestItem((ItemStack)item, shift ? 1 : -1, craftable);
                }
            }

            public void doubleClick(Widget<?> widget) {
            }
        });
        panel.addChild((Widget)blockRender);
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    private void requestItem(ItemStack stack, int amount, boolean craftable) {
        BlockPos selectedContainerPos = this.getSelectedContainerPos();
        if (selectedContainerPos == null) {
            return;
        }
        RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketRequestItem(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), selectedContainerPos, stack, amount, craftable));
        this.getInventoryOnServer();
    }

    private void changeRoutable(BlockPos c) {
        this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "scanner.toggleRoutable", TypedMap.builder().put(StorageScannerTileEntity.PARAM_POS, (Object)c).build());
        this.listDirty = 0;
    }

    private void updateStorageList() {
        this.storageList.removeChildren();
        this.addStorageLine(null, "All routable", false);
        for (PacketReturnInventoryInfo.InventoryInfo c : fromServer_inventories) {
            String displayName = c.getName();
            boolean routable = c.isRoutable();
            this.addStorageLine(c, displayName, routable);
        }
        this.storageList.clearHilightedRows();
        int i = 0;
        for (PacketReturnInventoryInfo.InventoryInfo c : fromServer_inventories) {
            if (fromServer_foundInventories.contains(c.getPos())) {
                this.storageList.addHilightedRow(i + 1);
            }
            ++i;
        }
    }

    private void addStorageLine(PacketReturnInventoryInfo.InventoryInfo c, String displayName, boolean routable) {
        Panel panel;
        if (c == null) {
            panel = new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(8)).setHorizontalMargin(5));
            panel.addChild((Widget)((ImageLabel)((ImageLabel)new ImageLabel(this.minecraft, (Screen)this).setImage(guielements, 115, 19)).setDesiredWidth(13)).setDesiredHeight(13));
        } else {
            HorizontalLayout layout = new HorizontalLayout();
            if (!this.openViewButton.isPressed()) {
                layout.setHorizontalMargin(2);
            }
            panel = new Panel(this.minecraft, (Screen)this).setLayout((Layout)layout);
            panel.addChild((Widget)new BlockRender(this.minecraft, (Screen)this).setRenderItem((Object)c.getBlock()));
        }
        if (this.openViewButton.isPressed()) {
            AbstractWidget label = ((Label)((Label)((Label)((Label)new Label(this.minecraft, (Screen)this).setColor(StyleConfig.colorTextInListNormal)).setText(displayName)).setDynamic(true)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(58);
            if (c == null) {
                label.setTooltips(new String[]{TextFormatting.GREEN + "All routable inventories"}).setDesiredWidth(74);
            } else {
                label.setTooltips(new String[]{TextFormatting.GREEN + "Block at: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)c.getPos()), TextFormatting.GREEN + "Name: " + TextFormatting.WHITE + displayName, "(doubleclick to highlight)"});
            }
            panel.addChild((Widget)label);
            if (c != null) {
                ImageChoiceLabel choiceLabel = (ImageChoiceLabel)new ImageChoiceLabel(this.minecraft, (Screen)this).addChoiceEvent((parent, newChoice) -> this.changeRoutable(c.getPos())).setDesiredWidth(13);
                choiceLabel.addChoice("No", "Not routable", guielements, 131, 19);
                choiceLabel.addChoice("Yes", "Routable", guielements, 115, 19);
                choiceLabel.setCurrentChoice(routable ? 1 : 0);
                panel.addChild((Widget)choiceLabel);
            }
        }
        this.storageList.addChild((Widget)panel);
    }

    protected void func_146976_a(float v, int i, int i2) {
        if (!this.init) {
            return;
        }
        this.updateStorageList();
        this.updateContentsList();
        this.requestListsIfNeeded();
        String text = this.radiusLabel.getText();
        if ("0".equals(text)) {
            text = "XNet";
        }
        this.visibleRadiusLabel.setText(text);
        int selected = this.storageList.getSelected();
        this.removeButton.setEnabled(selected != -1);
        if (selected <= 0 || this.storageList.getChildCount() <= 2) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.topButton.setEnabled(false);
            this.bottomButton.setEnabled(false);
        } else if (selected == 1) {
            this.topButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(true);
            this.bottomButton.setEnabled(true);
        } else if (selected == this.storageList.getChildCount() - 1) {
            this.topButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(false);
            this.bottomButton.setEnabled(false);
        } else {
            this.topButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
            this.bottomButton.setEnabled(true);
        }
        if (!((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            ((StorageScannerTileEntity)this.tileEntity).getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
                this.energyBar.setMaxValue(((GenericEnergyStorage)e).getCapacity());
                this.energyBar.setValue(((GenericEnergyStorage)e).getEnergy());
            });
            this.exportToStarred.setCurrentChoice(((StorageScannerTileEntity)this.tileEntity).isExportToCurrent() ? 0 : 1);
        } else {
            if (System.currentTimeMillis() - lastTime > 300L) {
                lastTime = System.currentTimeMillis();
                ((StorageScannerTileEntity)this.tileEntity).requestDataFromServer(RFToolsStorageMessages.INSTANCE, "getScannerInfo", TypedMap.EMPTY);
            }
            this.energyBar.setValue(StorageScannerTileEntity.rfReceived);
            this.exportToStarred.setCurrentChoice(StorageScannerTileEntity.exportToCurrentReceived ? 0 : 1);
        }
        this.drawWindow();
    }

    protected void func_146979_b(int i1, int i2) {
        if (!this.init) {
            return;
        }
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(tooltips, this.window.getTooltipItems(), x - this.field_147003_i, y - this.field_147009_r, this.minecraft.field_71466_p);
        }
        super.func_146979_b(i1, i2);
    }

    protected void drawStackTooltips(int mouseX, int mouseY) {
        if (this.init) {
            super.drawStackTooltips(mouseX, mouseY);
        }
    }

    protected List<String> addCustomLines(List<String> oldList, BlockRender blockRender, ItemStack stack) {
        if (blockRender.getUserObject() instanceof Integer) {
            ArrayList<String> newlist = new ArrayList<String>();
            newlist.add(TextFormatting.GREEN + "Click: " + TextFormatting.WHITE + "full stack");
            newlist.add(TextFormatting.GREEN + "Shift + click: " + TextFormatting.WHITE + "single item");
            newlist.add("");
            newlist.addAll(oldList);
            return newlist;
        }
        return oldList;
    }

    protected void drawWindow() {
        if (!this.init) {
            return;
        }
        super.drawWindow();
        this.craftingGrid.draw();
    }
}

