/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.items;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.storage.IStorageModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.storage.StorageEntry;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class StorageModuleItem
extends Item
implements INBTPreservingIngredient,
IStorageModuleItem {
    public static final int STORAGE_TIER1 = 0;
    public static final int STORAGE_TIER2 = 1;
    public static final int STORAGE_TIER3 = 2;
    public static final int STORAGE_TIER4 = 3;
    public static final int STORAGE_REMOTE = 6;
    public static final int[] MAXSIZE = new int[]{100, 200, 300, 500, 0, 0, -1};
    private final int tier;

    public StorageModuleItem(int tier) {
        super(new Item.Properties().func_200917_a(1).func_200918_c(0).func_200916_a(RFToolsStorage.setup.getTab()));
        this.tier = tier;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity player) {
        CompoundNBT tag;
        if (player != null && !(tag = stack.func_196082_o()).func_74764_b("createdBy")) {
            tag.func_74778_a("createdBy", player.func_200200_C_().func_150254_d());
        }
    }

    public static UUID getOrCreateUUID(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof StorageModuleItem)) {
            throw new RuntimeException("This is not supposed to happen! Needs to be a storage item!");
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_186855_b("uuid")) {
            nbt.func_186854_a("uuid", UUID.randomUUID());
            nbt.func_74768_a("version", 0);
        }
        return nbt.func_186857_a("uuid");
    }

    public static String getCreatedBy(ItemStack storageCard) {
        if (storageCard.func_77942_o()) {
            return storageCard.func_77978_p().func_74779_i("createdBy");
        }
        return null;
    }

    public static int getVersion(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("version");
        }
        return 0;
    }

    public static int getSize(ItemStack storageCard) {
        if (storageCard.func_77973_b() instanceof StorageModuleItem) {
            int tier = ((StorageModuleItem)storageCard.func_77973_b()).tier;
            return MAXSIZE[tier];
        }
        return 0;
    }

    public Collection<String> getTagsToPreserve() {
        return Arrays.asList("uuidMost", "uuidLeast");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Place this module in a storage module tablet to access contents"));
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, worldIn, list, flags);
        int max = MAXSIZE[this.tier];
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            StorageModuleItem.addModuleInformation(itemStack, list, max, tagCompound);
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This storage module is for the Modular Storage block."));
            if (max == -1) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This module supports a remote inventory."));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Link to another storage module in the remote storage block."));
            } else {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This module supports " + max + " stacks"));
            }
            if (tagCompound != null) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "UUID: " + tagCompound.func_186857_a("uuid").toString()));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "version: " + tagCompound.func_74762_e("version")));
            }
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    public static void addModuleInformation(ItemStack stack, List<ITextComponent> list, int max, CompoundNBT tagCompound) {
        int version;
        UUID uuid;
        StorageEntry storage;
        if (max == -1) {
            if (tagCompound.func_74764_b("id")) {
                int id = tagCompound.func_74762_e("id");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Remote id: " + id));
            } else {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Unlinked"));
            }
        } else if (tagCompound.func_186855_b("uuid") && (storage = RFToolsStorage.setup.clientStorageHolder.getStorage(uuid = tagCompound.func_186857_a("uuid"), version = tagCompound.func_74762_e("version"))) != null) {
            NonNullList<ItemStack> stacks = storage.getStacks();
            int cnt = 0;
            for (ItemStack s : stacks) {
                if (s.func_190926_b()) continue;
                ++cnt;
            }
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Contents " + TextFormatting.YELLOW + cnt + "/" + max + " stacks"));
            if (McJtyLib.proxy.isShiftKeyDown()) {
                String createdBy = storage.getCreatedBy();
                if (createdBy != null && !createdBy.isEmpty()) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Created by " + TextFormatting.YELLOW + createdBy));
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date creationTime = new Date(storage.getCreationTime());
                Date updateTime = new Date(storage.getUpdateTime());
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Creation time " + TextFormatting.YELLOW + dateFormat.format(creationTime)));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Update time " + TextFormatting.YELLOW + dateFormat.format(updateTime)));
            }
        }
    }
}

