/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.client;

import java.awt.Rectangle;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.GuiTools;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.GuiCraftingGrid;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageConfiguration;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import mcjty.rftoolsstorage.storage.modules.DefaultTypeModule;
import mcjty.rftoolsstorage.storage.modules.TypeModule;
import mcjty.rftoolsstorage.storage.sorters.ItemSorter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity, ModularStorageContainer> {
    public static final int STORAGE_WIDTH = 256;
    public static final String VIEW_LIST = "list";
    public static final String VIEW_COLUMNS = "columns";
    public static final String VIEW_ICONS = "icons";
    private TypeModule typeModule;
    private static final ResourceLocation iconLocationTop = new ResourceLocation("rftoolsstorage", "textures/gui/modularstoragetop.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsstorage", "textures/gui/modularstorage.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private WidgetList itemList;
    private TextField filter;
    private ImageChoiceLabel viewMode;
    private ImageChoiceLabel sortMode;
    private ImageChoiceLabel groupMode;
    private Label amountLabel;
    private Button cycleButton;
    private Button compactButton;
    private GuiCraftingGrid craftingGrid = new GuiCraftingGrid();

    public GuiModularStorage(ModularStorageTileEntity tileEntity, ModularStorageContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsStorage.instance, (GenericTileEntity)tileEntity, (Container)container, inventory, 0, "storage");
        this.field_146999_f = 256;
        double height = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        this.field_147000_g = height > 510.0 ? (Integer)ModularStorageConfiguration.height3.get() : (height > 340.0 ? ((Integer)ModularStorageConfiguration.height2.get()).intValue() : ((Integer)ModularStorageConfiguration.height1.get()).intValue());
    }

    public void init() {
        super.init();
        this.itemList = ((WidgetList)((WidgetList)((WidgetList)new WidgetList(this.minecraft, (Screen)this).setName("items")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 3, 235, this.field_147000_g - 89))).setNoSelectionMode(true).setUserObject((Object)new Integer(-1))).setLeftMargin(0).setRowheight(-1);
        Slider slider = ((Slider)((Slider)new Slider(this.minecraft, (Screen)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(241, 3, 11, this.field_147000_g - 89))).setDesiredWidth(11)).setVertical().setScrollableName("items");
        Panel modePanel = this.setupModePanel();
        this.cycleButton = (Button)((Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setName("cycle")).setChannel("cycle")).setText("C")).setTooltips(new String[]{"Cycle to the next storage module"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, this.field_147000_g - 23, 16, 16));
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.itemList)).addChild((Widget)slider)).addChild((Widget)modePanel)).addChild((Widget)this.cycleButton);
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.field_147000_g - (Integer)ModularStorageConfiguration.height1.get() + 2);
        if (this.tileEntity == null) {
            ImageLabel hideLabel = new ImageLabel(this.minecraft, (Screen)this);
            hideLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, this.field_147000_g - 26 - 54, 20, 55));
            hideLabel.setImage(guiElements, 32, 32);
            toplevel.addChild((Widget)hideLabel);
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cycle", (source, params) -> this.cycleStorage());
        this.window.event("compact", (source, params) -> this.compact());
        if (((Boolean)ModularStorageConfiguration.autofocusSearch.get()).booleanValue()) {
            this.window.setTextFocus((Widget)this.filter);
        }
        CraftingGridProvider provider = null;
        BlockPos pos = null;
        if (this.tileEntity == null) {
            throw new RuntimeException("Should not happen!");
        }
        provider = (CraftingGridProvider)this.tileEntity;
        pos = ((ModularStorageTileEntity)this.tileEntity).func_174877_v();
        this.craftingGrid.initGui(this.modBase, RFToolsStorageMessages.INSTANCE, this.minecraft, this, pos, provider, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).build());
    }

    private Panel setupModePanel() {
        this.filter = ((TextField)((TextField)new TextField(this.minecraft, (Screen)this).setLayoutHint(3, 3, 57, 13)).setTooltips(new String[]{"Name based filter for items"})).addTextEvent((parent, newText) -> this.updateSettings());
        this.viewMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.minecraft, (Screen)this).setLayoutHint(4, 19, 16, 16)).setTooltips(new String[]{"Control how items are shown", "in the view"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.viewMode.addChoice(VIEW_LIST, "Items are shown in a list view", guiElements, 144, 16);
        this.viewMode.addChoice(VIEW_COLUMNS, "Items are shown in columns", guiElements, 160, 16);
        this.viewMode.addChoice(VIEW_ICONS, "Items are shown with icons", guiElements, 176, 16);
        this.updateTypeModule();
        this.sortMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.minecraft, (Screen)this).setLayoutHint(23, 19, 16, 16)).setTooltips(new String[]{"Control how items are sorted", "in the view"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.addChoice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        this.groupMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.minecraft, (Screen)this).setLayoutHint(42, 19, 16, 16)).setTooltips(new String[]{"If enabled it will show groups", "based on sorting criterium"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.groupMode.addChoice("Off", "Don't show groups", guiElements, 208, 0);
        this.groupMode.addChoice("On", "Show groups", guiElements, 224, 0);
        this.amountLabel = new Label(this.minecraft, (Screen)this);
        this.amountLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.amountLabel.setLayoutHint(16, 40, 66, 12);
        this.amountLabel.setTooltips(new String[]{"Amount of stacks / maximum amount"});
        this.amountLabel.setText("?/?");
        this.compactButton = (Button)((Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setName("compact")).setChannel("compact")).setLayoutHint(4, 39, 12, 12)).setText("z")).setTooltips(new String[]{"Compact equal stacks"});
        if (this.tileEntity != null) {
            this.filter.setText((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : ((ModularStorageTileEntity)this.tileEntity).getFilter());
            this.setViewMode(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.setSortMode(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
        } else {
            ItemStack heldItem = this.minecraft.field_71439_g.func_184586_b(Hand.MAIN_HAND);
            if (!heldItem.func_190926_b() && heldItem.func_77942_o()) {
                CompoundNBT tagCompound = heldItem.func_77978_p();
                this.filter.setText((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : tagCompound.func_74779_i("filter"));
                this.setViewMode(tagCompound.func_74779_i("viewMode"));
                this.setSortMode(tagCompound.func_74779_i("sortMode"));
                this.groupMode.setCurrentChoice(tagCompound.func_74767_n("groupMode") ? 1 : 0);
            }
        }
        return (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(24, this.field_147000_g - 80, 64, 77))).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).addChildren(new Widget[]{this.filter, this.viewMode, this.sortMode, this.groupMode, this.amountLabel, this.compactButton});
    }

    private void setSortMode(String sortMode) {
        int idx = this.sortMode.findChoice(sortMode);
        if (idx == -1) {
            this.sortMode.setCurrentChoice(0);
        } else {
            this.sortMode.setCurrentChoice(idx);
        }
    }

    private void setViewMode(String viewMode) {
        int idx = this.viewMode.findChoice(viewMode);
        if (idx == -1) {
            this.viewMode.setCurrentChoice(VIEW_LIST);
        } else {
            this.viewMode.setCurrentChoice(idx);
        }
    }

    private void cycleStorage() {
        if (this.tileEntity != null) {
            this.window.sendAction(RFToolsStorageMessages.INSTANCE, this.tileEntity, "cycle");
        } else {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "cycleStorage");
        }
    }

    private void compact() {
        if (this.tileEntity != null) {
            this.window.sendAction(RFToolsStorageMessages.INSTANCE, this.tileEntity, "compact");
        } else {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "compact");
        }
    }

    private void updateSettings() {
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).setSortMode(this.sortMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setViewMode(this.viewMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setFilter(this.filter.getText());
            ((ModularStorageTileEntity)this.tileEntity).setGroupMode(this.groupMode.getCurrentChoiceIndex() == 1);
            this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, "storage.settings", TypedMap.builder().put(ModularStorageTileEntity.PARAM_SORTMODE, (Object)this.sortMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_VIEWMODE, (Object)this.viewMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_FILTER, (Object)this.filter.getText()).put(ModularStorageTileEntity.PARAM_GROUPMODE, (Object)(this.groupMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).build());
        }
    }

    private Slot findEmptySlot() {
        for (Object slotObject : ((ModularStorageContainer)this.field_147002_h).field_75151_b) {
            Slot slot = (Slot)slotObject;
            if (this.tileEntity != null && !(slot instanceof BaseSlot) || slot.func_75216_d() && slot.func_75211_c().func_190916_E() != 0) continue;
            return slot;
        }
        return null;
    }

    public boolean func_195362_a(Slot slotIn, double x, double y) {
        if (slotIn instanceof BaseSlot && ((BaseSlot)slotIn).getTe() instanceof ModularStorageTileEntity) {
            Widget widget = this.window.getToplevel().getWidgetAtPosition((int)x, (int)y);
            if (widget instanceof BlockRender) {
                Object userObject = widget.getUserObject();
                if (userObject instanceof Integer) {
                    Integer slotIndex = (Integer)userObject;
                    return slotIndex == slotIn.field_75222_d;
                }
            } else {
                return super.func_195362_a(slotIn, x, y);
            }
            return false;
        }
        return super.func_195362_a(slotIn, x, y);
    }

    public Slot func_195360_a(double x, double y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition((int)x, (int)y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return ((ModularStorageContainer)this.field_147002_h).func_75139_a(slotIndex);
            }
            return this.findEmptySlot();
        }
        return super.func_195360_a(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + o.getClass().getGenericSuperclass()));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        Slot slot;
        boolean r = super.mouseClicked(x, y, button);
        this.craftingGrid.getWindow().mouseClicked((int)x, (int)y, button);
        if (button == 1 && (slot = this.func_195360_a(x, y)) instanceof GhostOutputSlot) {
            if (this.tileEntity != null) {
                this.window.sendAction(RFToolsStorageMessages.INSTANCE, this.tileEntity, "clearGrid");
            } else {
                this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "clearGrid");
            }
        }
        return r;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        this.craftingGrid.getWindow().handleMouseInput(button);
        return super.mouseDragged(x, y, button, scaledX, scaledY);
    }

    public boolean mouseReleased(double x, double y, int state) {
        boolean rc = super.mouseReleased(x, y, state);
        this.craftingGrid.getWindow().mouseMovedOrUp((int)x, (int)y, state);
        return rc;
    }

    private void updateList() {
        int spacing;
        int labelWidth;
        int numcolumns;
        this.itemList.removeChildren();
        if (this.tileEntity != null && !((ModularStorageContainer)this.field_147002_h).func_75139_a(0).func_75216_d()) {
            this.amountLabel.setText("(empty)");
            this.compactButton.setEnabled(false);
            this.cycleButton.setEnabled(false);
            return;
        }
        this.cycleButton.setEnabled(this.isTabletWithRemote() || this.isRemote());
        String filterText = this.filter.getText().toLowerCase().trim();
        String view = this.viewMode.getCurrentChoice();
        if (VIEW_LIST.equals(view)) {
            numcolumns = 1;
            labelWidth = 210;
            spacing = 5;
        } else if (VIEW_COLUMNS.equals(view)) {
            numcolumns = 2;
            labelWidth = 86;
            spacing = 5;
        } else {
            numcolumns = 12;
            labelWidth = 0;
            spacing = 3;
        }
        AtomicInteger max = new AtomicInteger();
        ArrayList items = new ArrayList();
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    String displayName = stack.func_200301_q().func_150254_d();
                    if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                    items.add(Pair.of((Object)stack, (Object)(i + 3)));
                }
                max.set(handler.getSlots());
            });
        }
        this.amountLabel.setText(items.size() + "/" + max);
        this.compactButton.setEnabled(max.get() > 0);
        int sort = this.getCurrentSortMode();
        boolean dogroups = this.groupMode.getCurrentChoiceIndex() == 1;
        ItemSorter itemSorter = this.typeModule.getSorters().get(sort);
        Collections.sort(items, itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        Pair prevItem = null;
        for (Pair item : items) {
            currentPos = this.addItemToList((ItemStack)item.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)item.getValue(), dogroups && (prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)item)), itemSorter.getGroupName((Pair<ItemStack, Integer>)item));
            prevItem = item;
        }
        int newfirst = -1;
        if (this.itemList.getCountSelected() == 0) {
            if (this.itemList.getBounds() != null) {
                this.itemList.setFirstSelected(0);
                newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
                if (newfirst < 0) {
                    newfirst = 0;
                }
            }
        } else if (this.itemList.getFirstSelected() > this.itemList.getChildCount() - this.itemList.getCountSelected()) {
            newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
        }
        if (newfirst >= 0) {
            this.itemList.setFirstSelected(newfirst);
        }
    }

    private boolean isRemote() {
        return false;
    }

    private boolean isTabletWithRemote() {
        if (this.tileEntity != null) {
            return false;
        }
        ItemStack heldItem = this.minecraft.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (!heldItem.func_190926_b() && heldItem.func_77942_o()) {
            int storageType = heldItem.func_77978_p().func_74762_e("childDamage");
            return storageType == 6;
        }
        return false;
    }

    private int getCurrentSortMode() {
        this.updateTypeModule();
        String sortName = this.sortMode.getCurrentChoice();
        this.sortMode.clear();
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.addChoice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        int sort = this.sortMode.findChoice(sortName);
        if (sort == -1) {
            sort = 0;
        }
        this.sortMode.setCurrentChoice(sort);
        return sort;
    }

    private void updateTypeModule() {
        ItemStack typeStack;
        this.typeModule = this.tileEntity != null ? ((typeStack = ItemStack.field_190927_a).func_190926_b() || !(typeStack.func_77973_b() instanceof TypeModule) ? new DefaultTypeModule() : (TypeModule)typeStack.func_77973_b()) : new DefaultTypeModule();
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                AbstractWidget groupLabel = ((Label)((Label)((Label)((Label)((Label)((Label)new Label(this.minecraft, (Screen)this).setText(groupName)).setColor(((Integer)ModularStorageConfiguration.groupForeground.get()).intValue())).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setFilledBackground(((Integer)ModularStorageConfiguration.groupBackground.get()).intValue())).setDesiredHeight(10)).setDesiredWidth(231);
                itemList.addChild((Widget)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(2)).setVerticalMargin(0)).setDesiredHeight(10)).addChild((Widget)groupLabel));
            }
            panel = (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout().setSpacing(spacing)).setDesiredHeight(12)).setUserObject((Object)new Integer(-1))).setDesiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.addChild((Widget)panel);
        }
        BlockRender blockRender = ((BlockRender)new BlockRender(this.minecraft, (Screen)this).setRenderItem((Object)stack).setUserObject((Object)slot)).setOffsetX(-1).setOffsetY(-1);
        panel.addChild((Widget)blockRender);
        if (labelWidth > 0) {
            String displayName = labelWidth > 100 ? this.typeModule.getLongLabel(stack) : this.typeModule.getShortLabel(stack);
            AbstractWidget label = ((Label)((Label)((Label)((Label)new Label(this.minecraft, (Screen)this).setText(displayName)).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(labelWidth)).setUserObject((Object)new Integer(-1));
            panel.addChild((Widget)label);
        }
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean rc = false;
        if (!this.window.keyTyped(keyCode, scanCode)) {
            if (keyCode >= 49 && keyCode <= 57) {
                return true;
            }
            rc = super.keyPressed(keyCode, scanCode, modifiers);
        }
        this.craftingGrid.getWindow().keyTyped(keyCode, keyCode);
        return rc;
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateList();
        if (this.tileEntity != null) {
            this.viewMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.sortMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
            String curFilter = ((ModularStorageTileEntity)this.tileEntity).getFilter();
            if (!this.filter.getText().equals(curFilter)) {
                this.filter.setText(curFilter);
            }
        }
        this.drawWindow();
    }

    protected void func_146979_b(int i1, int i2) {
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(tooltips, this.window.getTooltipItems(), x - this.field_147003_i, y - this.field_147009_r, this.minecraft.field_71466_p);
        }
        super.func_146979_b(i1, i2);
    }

    protected void drawWindow() {
        super.drawWindow();
        this.craftingGrid.draw();
    }
}

