/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.blocks;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.api.storage.IInventoryTracker;
import mcjty.rftoolsbase.api.storage.IModularStorage;
import mcjty.rftoolsbase.modules.various.FilterModuleCache;
import mcjty.rftoolsbase.modules.various.items.FilterModuleItem;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.InventoriesItemSource;
import mcjty.rftoolsstorage.craftinggrid.StorageCraftingTools;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageSetup;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.GlobalStorageItemWrapper;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ModularStorageTileEntity
extends GenericTileEntity
implements IInventoryTracker,
CraftingGridProvider,
JEIRecipeAcceptor,
IModularStorage {
    public static final String CMD_SETTINGS = "storage.settings";
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<String> PARAM_VIEWMODE = new Key("viewmode", Type.STRING);
    public static final Key<String> PARAM_SORTMODE = new Key("sortmode", Type.STRING);
    public static final Key<Boolean> PARAM_GROUPMODE = new Key("groupmode", Type.BOOLEAN);
    public static final String ACTION_COMPACT = "compact";
    public static final String ACTION_CYCLE = "cycle";
    public static final String ACTION_CLEARGRID = "clearGrid";
    private FilterModuleCache filterCache = null;
    private LazyOptional<IItemHandler> globalHandler = LazyOptional.of(this::createGlobalHandler);
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Modular Storage").containerSupplier((windowId, player) -> new ModularStorageContainer((int)windowId, this.func_174877_v(), (PlayerEntity)player, this)).itemHandler(() -> (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h).orElseThrow(RuntimeException::new)));
    private GlobalStorageItemWrapper globalWrapper;
    private ItemStackHandler cardHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            if (slot == 0) {
                if (ModularStorageTileEntity.this.globalWrapper != null) {
                    StorageInfo info = ModularStorageTileEntity.this.getStorageInfo();
                    ModularStorageTileEntity.this.globalWrapper.setInfo(info);
                }
            } else if (slot == 2) {
                ModularStorageTileEntity.this.filterCache = null;
            }
            ModularStorageTileEntity.this.markDirtyClient();
        }
    };
    private CraftingGrid craftingGrid = new CraftingGrid();
    private String sortMode = "";
    private String viewMode = "";
    private boolean groupMode = false;
    private String filter = "";

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_COMPACT, this::compact), new DefaultAction(ACTION_CYCLE, this::cycle), new DefaultAction(ACTION_CLEARGRID, this::clearGrid)};
    }

    public ModularStorageTileEntity() {
        super((TileEntityType)ModularStorageSetup.TYPE_MODULAR_STORAGE.get());
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setStackInSlot(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(PlayerEntity player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), 0);
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> itemSource.add((IItemHandler)h, 0));
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return new int[0];
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.func_70296_d();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.func_70296_d();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.func_70296_d();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.func_70296_d();
    }

    public int getRenderLevel() {
        return 0;
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
    }

    public void writeClientDataToNBT(CompoundNBT tagCompound) {
    }

    public void syncInventoryFromServer(String sortMode, String viewMode, boolean groupMode, String filter) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.sortMode = tagCompound.func_74779_i("sortMode");
        this.viewMode = tagCompound.func_74779_i("viewMode");
        this.groupMode = tagCompound.func_74767_n("groupMode");
        this.filter = tagCompound.func_74779_i("filter");
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    protected void readCaps(CompoundNBT tagCompound) {
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            this.cardHandler.deserializeNBT(infoTag.func_74775_l("Cards"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("sortMode", this.sortMode);
        tagCompound.func_74778_a("viewMode", this.viewMode);
        tagCompound.func_74757_a("groupMode", this.groupMode);
        tagCompound.func_74778_a("filter", this.filter);
        tagCompound.func_218657_a("grid", (INBT)this.craftingGrid.writeToNBT());
        return tagCompound;
    }

    protected void writeCaps(CompoundNBT tagCompound) {
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_218657_a("Cards", (INBT)this.cardHandler.serializeNBT());
    }

    private void writeCardStack(CompoundNBT tagCompound, String cardName, ItemStack card) {
        CompoundNBT storageNBT = new CompoundNBT();
        card.func_77955_b(storageNBT);
        tagCompound.func_218657_a(cardName, (INBT)storageNBT);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            this.setFilter((String)params.get(PARAM_FILTER));
            this.setViewMode((String)params.get(PARAM_VIEWMODE));
            this.setSortMode((String)params.get(PARAM_SORTMODE));
            this.setGroupMode((Boolean)params.get(PARAM_GROUPMODE));
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    private void cycle() {
    }

    private void compact() {
    }

    @Nonnull
    public StorageInfo getStorageInfo() {
        ItemStack storageCard = this.cardHandler.getStackInSlot(0);
        if (storageCard.func_190926_b()) {
            return StorageInfo.EMPTY;
        }
        Item item = storageCard.func_77973_b();
        if (item instanceof StorageModuleItem) {
            UUID uuid = StorageModuleItem.getOrCreateUUID(storageCard);
            int version = StorageModuleItem.getVersion(storageCard);
            int size = StorageModuleItem.getSize(storageCard);
            String createdBy = StorageModuleItem.getCreatedBy(storageCard);
            return new StorageInfo(uuid, version, size, createdBy);
        }
        return StorageInfo.EMPTY;
    }

    public int getVersion() {
        return this.getStorageInfo().getVersion();
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = FilterModuleItem.getCache((ItemStack)this.cardHandler.getStackInSlot(2));
        }
    }

    @Nonnull
    private IItemHandlerModifiable createGlobalHandler() {
        StorageInfo info = this.getStorageInfo();
        if (this.globalWrapper == null) {
            this.globalWrapper = new GlobalStorageItemWrapper(info, this.field_145850_b.field_72995_K){

                @Override
                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    boolean rc = super.isItemValid(slot, stack);
                    if (!rc) {
                        return false;
                    }
                    if (!ModularStorageTileEntity.this.cardHandler.getStackInSlot(2).func_190926_b()) {
                        ModularStorageTileEntity.this.getFilterCache();
                        if (ModularStorageTileEntity.this.filterCache != null) {
                            return ModularStorageTileEntity.this.filterCache.match(stack);
                        }
                    }
                    return true;
                }
            };
            if (!this.field_145850_b.field_72995_K) {
                this.globalWrapper.setListener((version, slot) -> {
                    ItemStack storageSlot = this.cardHandler.getStackInSlot(0);
                    if (storageSlot.func_77973_b() instanceof StorageModuleItem) {
                        storageSlot.func_196082_o().func_74768_a("version", version);
                    }
                    this.markDirtyQuick();
                });
            }
        } else {
            this.globalWrapper.setInfo(info);
        }
        return this.globalWrapper;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.globalHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    public IItemHandler getCardHandler() {
        return this.cardHandler;
    }
}

