/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.craftingmanager.CraftingManagerSetup;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerContainer;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingQueue;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingRequest;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingSystem;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingManagerTileEntity
extends GenericTileEntity {
    public static final ModelProperty<BlockState>[] MIMIC = new ModelProperty[]{new ModelProperty(), new ModelProperty(), new ModelProperty(), new ModelProperty()};
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::createItemHandler);
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Modular Storage").containerSupplier((windowId, player) -> new CraftingManagerContainer((int)windowId, this.func_174877_v(), (PlayerEntity)player, this)).itemHandler(() -> (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h).orElseThrow(RuntimeException::new)));
    private CraftingQueue[] queues = new CraftingQueue[4];
    public static final double QUALITY_NOTPOSSIBLE = -1.0;
    public static final double QUALITY_DEVICEIDLE = 10000.0;

    public CraftingManagerTileEntity() {
        super((TileEntityType)CraftingManagerSetup.TYPE_CRAFTING_MANAGER.get());
        for (int i = 0; i < 4; ++i) {
            this.queues[i] = new CraftingQueue();
        }
    }

    public boolean tick(CraftingSystem system) {
        return (Boolean)this.itemHandler.map(h -> {
            boolean rc = false;
            for (int queueIndex = 0; queueIndex < 4; ++queueIndex) {
                if (!this.queues[queueIndex].hasDevice()) continue;
                ICraftingDevice device = this.queues[queueIndex].getDevice();
                device.tick();
                if (device.getStatus() != ICraftingDevice.Status.READY) continue;
                this.sendResultsBack(queueIndex, system);
                rc = true;
            }
            return rc;
        }).orElse((Object)false);
    }

    private void sendResultsBack(int queueIndex, CraftingSystem system) {
        List<ItemStack> output = this.queues[queueIndex].getDevice().extractOutput();
        StorageScannerTileEntity storage = system.getStorage();
        for (ItemStack stack : output) {
            ItemStack left = storage.insertInternal(stack, false);
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)storage.func_174877_v().func_177958_n() + 0.5), (double)((double)storage.func_174877_v().func_177956_o() + 1.5), (double)((double)storage.func_174877_v().func_177952_p() + 0.5), (ItemStack)left);
        }
    }

    public boolean canCraft(Ingredient ingredient) {
        return (Boolean)this.itemHandler.map(h -> {
            for (int i = 4; i < h.getSlots(); ++i) {
                ItemStack result;
                ItemStack card = h.getStackInSlot(i);
                if (card.func_190926_b() || !ingredient.test(result = CraftingCardItem.getResult((ItemStack)card))) continue;
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    public List<ItemStack> getCraftables() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.itemHandler.ifPresent(h -> {
            for (int i = 4; i < h.getSlots(); ++i) {
                ItemStack result;
                ItemStack card = h.getStackInSlot(i);
                if (card.func_190926_b() || (result = CraftingCardItem.getResult((ItemStack)card)).func_190926_b()) continue;
                stacks.add(result);
            }
        });
        return stacks;
    }

    public Pair<Double, Integer> getCraftingQuality(Ingredient ingredient, int amount) {
        return (Pair)this.itemHandler.map(h -> {
            double bestQuality = -1.0;
            int bestDevice = -1;
            for (int queueIndex = 0; queueIndex < 4; ++queueIndex) {
                if (!this.queues[queueIndex].hasDevice()) continue;
                ICraftingDevice device = this.queues[queueIndex].getDevice();
                Queue<CraftingRequest> requests = this.queues[queueIndex].getRequests();
                double baseQuality = Math.max(0.0, 1.0 - (double)requests.size() / 10.0);
                switch (device.getStatus()) {
                    case IDLE: {
                        baseQuality += 10000.0;
                        break;
                    }
                    case READY: {
                        baseQuality += 0.5;
                        break;
                    }
                }
                double quality = -1.0;
                for (int i = this.getFirstCardIndex(queueIndex); i < this.getLastCardIndex(queueIndex); ++i) {
                    ItemStack result;
                    ItemStack card = h.getStackInSlot(queueIndex);
                    if (card.func_190926_b() || !ingredient.test(result = CraftingCardItem.getResult((ItemStack)card))) continue;
                    quality = baseQuality;
                    break;
                }
                if (!(quality >= 0.0) || !(quality > bestQuality)) continue;
                bestQuality = quality;
                bestDevice = queueIndex;
            }
            return Pair.of((Object)bestQuality, (Object)bestDevice);
        }).orElse((Object)Pair.of((Object)-1.0, (Object)-1));
    }

    private int getLastCardIndex(int queueIndex) {
        return 4 + queueIndex * 8 + 8;
    }

    private int getFirstCardIndex(int queueIndex) {
        return 4 + queueIndex * 8;
    }

    public CraftingQueue[] getQueues() {
        return this.queues;
    }

    @Nonnull
    public List<Ingredient> getIngredients(int queueIndex, CraftingRequest request) {
        return (List)this.itemHandler.map(h -> {
            CraftingQueue queue = this.queues[queueIndex];
            for (int i = this.getFirstCardIndex(queueIndex); i < this.getLastCardIndex(queueIndex); ++i) {
                ItemStack cardStack = h.getStackInSlot(i);
                if (cardStack.func_190926_b()) continue;
                ItemStack cardResult = CraftingCardItem.getResult((ItemStack)cardStack);
                if (!request.getIngredient().test(cardResult)) continue;
                IRecipe recipe = CraftingCardItem.findRecipe((World)this.field_145850_b, (ItemStack)cardStack, queue.getDevice().getRecipeType());
                Object ingredients = recipe != null ? recipe.func_192400_c() : CraftingCardItem.getIngredients((ItemStack)cardStack);
                return ingredients;
            }
            return Collections.emptyList();
        }).orElse(Collections.emptyList());
    }

    public boolean startCraft(int queueIndex, CraftingRequest request, List<ItemStack> ingredients) {
        CraftingQueue queue = this.queues[queueIndex];
        return queue.getDevice().insertIngredients(ingredients, this.field_145850_b);
    }

    private void updateDevices() {
        this.itemHandler.ifPresent(h -> {
            for (int i = 0; i < 4; ++i) {
                ItemStack deviceStack = h.getStackInSlot(i);
                ResourceLocation id = deviceStack.func_77973_b().getRegistryName();
                ICraftingDevice device = RFToolsStorage.setup.craftingDeviceRegistry.get(id);
                this.queues[i].setDevice(device);
            }
        });
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.itemHandler.ifPresent(h -> {
            ItemStack origMimic0 = h.getStackInSlot(0);
            ItemStack origMimic1 = h.getStackInSlot(1);
            ItemStack origMimic2 = h.getStackInSlot(2);
            ItemStack origMimic3 = h.getStackInSlot(3);
            this.readClientDataFromNBT(pkt.func_148857_g());
            ItemStack mimic0 = h.getStackInSlot(0);
            ItemStack mimic1 = h.getStackInSlot(1);
            ItemStack mimic2 = h.getStackInSlot(2);
            ItemStack mimic3 = h.getStackInSlot(3);
            if (!(ItemStack.func_179545_c((ItemStack)origMimic0, (ItemStack)mimic0) && ItemStack.func_179545_c((ItemStack)origMimic1, (ItemStack)mimic1) && ItemStack.func_179545_c((ItemStack)origMimic2, (ItemStack)mimic2) && ItemStack.func_179545_c((ItemStack)origMimic3, (ItemStack)mimic3))) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        });
    }

    @Nonnull
    public IModelData getModelData() {
        return (IModelData)this.itemHandler.map(h -> {
            BlockState mimic0 = h.getStackInSlot(0).func_190926_b() ? null : ((BlockItem)h.getStackInSlot(0).func_77973_b()).func_179223_d().func_176223_P();
            BlockState mimic1 = h.getStackInSlot(1).func_190926_b() ? null : ((BlockItem)h.getStackInSlot(1).func_77973_b()).func_179223_d().func_176223_P();
            BlockState mimic2 = h.getStackInSlot(2).func_190926_b() ? null : ((BlockItem)h.getStackInSlot(2).func_77973_b()).func_179223_d().func_176223_P();
            BlockState mimic3 = h.getStackInSlot(3).func_190926_b() ? null : ((BlockItem)h.getStackInSlot(3).func_77973_b()).func_179223_d().func_176223_P();
            return new ModelDataMap.Builder().withInitial(MIMIC[0], (Object)mimic0).withInitial(MIMIC[1], (Object)mimic1).withInitial(MIMIC[2], (Object)mimic2).withInitial(MIMIC[3], (Object)mimic3).build();
        }).orElseThrow(IllegalStateException::new);
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    @Nonnull
    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, CraftingManagerContainer.CONTAINER_FACTORY){

            protected void onUpdate(int index) {
                if (index < 4) {
                    CraftingManagerTileEntity.this.markDirtyClient();
                    CraftingManagerTileEntity.this.updateDevices();
                }
                super.onUpdate(index);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

