/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class CraftingGrid {
    private CraftingGridInventory craftingGridInventory = new CraftingGridInventory();
    private CraftingRecipe[] recipes = new CraftingRecipe[6];

    public CraftingGrid() {
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public CraftingGridInventory getCraftingGridInventory() {
        return this.craftingGridInventory;
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public CraftingRecipe getActiveRecipe() {
        CraftingRecipe recipe = new CraftingRecipe();
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
        return recipe;
    }

    public void setRecipe(int index, ItemStack[] stacks) {
        CraftingRecipe recipe = this.recipes[index];
        recipe.setResult(stacks[0]);
        for (int i = 0; i < 9; ++i) {
            recipe.getInventory().func_70299_a(i, stacks[i + 1]);
        }
    }

    public void storeRecipe(int index) {
        CraftingRecipe recipe = this.getRecipe(index);
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
    }

    public void selectRecipe(int index) {
        CraftingRecipe recipe = this.getRecipe(index);
        this.craftingGridInventory.setStackInSlot(CraftingGridInventory.SLOT_GHOSTOUTPUT, recipe.getResult());
        for (int i = 0; i < 9; ++i) {
            this.craftingGridInventory.setStackInSlot(i + CraftingGridInventory.SLOT_GHOSTINPUT, recipe.getInventory().func_70301_a(i));
        }
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tagCompound = new CompoundNBT();
        ListNBT bufferTagList = new ListNBT();
        for (int i = 0; i < this.craftingGridInventory.getSlots(); ++i) {
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            ItemStack stack = this.craftingGridInventory.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                stack.func_77955_b(CompoundNBT2);
            }
            bufferTagList.add((Object)CompoundNBT2);
        }
        tagCompound.func_218657_a("grid", (INBT)bufferTagList);
        ListNBT recipeTagList = new ListNBT();
        for (CraftingRecipe recipe : this.recipes) {
            CompoundNBT CompoundNBT3 = new CompoundNBT();
            recipe.writeToNBT(CompoundNBT3);
            recipeTagList.add((Object)CompoundNBT3);
        }
        tagCompound.func_218657_a("recipes", (INBT)recipeTagList);
        return tagCompound;
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        if (tagCompound == null) {
            return;
        }
        ListNBT bufferTagList = tagCompound.func_150295_c("grid", 10);
        for (int i = 0; i < this.craftingGridInventory.getSlots(); ++i) {
            CompoundNBT CompoundNBT2 = bufferTagList.func_150305_b(i);
            this.craftingGridInventory.setStackInSlot(i, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
        }
        ListNBT recipeTagList = tagCompound.func_150295_c("recipes", 10);
        for (int i = 0; i < recipeTagList.size(); ++i) {
            this.recipes[i] = new CraftingRecipe();
            CompoundNBT CompoundNBT3 = recipeTagList.func_150305_b(i);
            this.recipes[i].readFromNBT(CompoundNBT3);
        }
    }
}

