/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.GsonUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class CommonProvider
implements IDataProvider {
    public static final Logger LOGGER = LogManager.getLogger((String)"DataGenerator");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Marker marker;
    protected final GenerationData data;
    protected final String modid;
    protected final DataGenerator generator;
    protected final Path path;

    public CommonProvider(GenerationData data) {
        this.data = data;
        this.generator = data.getGenerator();
        this.modid = data.getModid();
        this.path = this.generator.func_200391_b();
        this.marker = MarkerManager.getMarker((String)this.func_200397_b());
    }

    public ResourceLocation modLoc(String path) {
        return new ResourceLocation(this.modid, path);
    }

    public ResourceLocation mcLoc(String path) {
        return new ResourceLocation(path);
    }

    public Path resolveModData() {
        return this.path.resolve("data").resolve(this.modid);
    }

    public Path resolveModAssets() {
        return this.path.resolve("assets").resolve(this.modid);
    }

    public Path resolveData(ResourceLocation location) {
        return this.path.resolve("data").resolve(location.func_110624_b());
    }

    public Path resolveAssets(ResourceLocation location) {
        return this.path.resolve("assets").resolve(location.func_110624_b());
    }

    public static void write(DirectoryCache cache, JsonElement element, Path path) throws IOException {
        CommonProvider.write(cache, element, path, GSON);
    }

    public static void write(DirectoryCache cache, JsonElement element, Path path, Gson gson) throws IOException {
        try (StringWriter writer = new StringWriter();
             JsonWriter jsonWriter = GsonUtil.createTabWriter(gson, writer);){
            GSON.toJson(element, jsonWriter);
            CommonProvider.write(cache, writer.toString(), path);
        }
        catch (IOException ex) {
            throw new JsonIOException((Throwable)ex);
        }
    }

    public static void write(DirectoryCache cache, String string, Path path) throws IOException {
        String hash = field_208307_a.hashUnencodedChars((CharSequence)string).toString();
        if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(string);
            }
        }
        cache.func_208316_a(path, hash);
    }
}

