/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.blocks.te;

import com.chaosthedude.endermail.blocks.LockerBlock;
import com.chaosthedude.endermail.data.LockerWorldData;
import com.chaosthedude.endermail.gui.container.LockerContainer;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import com.chaosthedude.endermail.registry.EnderMailItems;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LockerTileEntity
extends TileEntity
implements IInventory,
INamedContainerProvider {
    public static final String NAME = "locker";
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    protected String lockerID = "";

    public LockerTileEntity() {
        super(EnderMailBlocks.LOCKER_TE_TYPE);
    }

    public LockerTileEntity(NonNullList<ItemStack> contents) {
        this();
        this.contents = contents;
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.contents) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.contents);
        this.lockerID = compound.func_74779_i("LockerID");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.contents);
        compound.func_74778_a("LockerID", this.lockerID);
        return compound;
    }

    public CompoundNBT writeItems(CompoundNBT compound) {
        if (!this.contents.isEmpty()) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.contents);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack result = ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
        LockerBlock.setFilled(!this.func_191420_l(), this.field_145850_b, this.field_174879_c);
        return result;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack result = ItemStackHelper.func_188383_a(this.contents, (int)index);
        LockerBlock.setFilled(!this.func_191420_l(), this.field_145850_b, this.field_174879_c);
        return result;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.contents.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.contents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        LockerBlock.setFilled(!this.func_191420_l(), this.field_145850_b, this.field_174879_c);
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == EnderMailItems.PACKAGE;
    }

    public void func_174888_l() {
        this.contents.clear();
        LockerBlock.setFilled(!this.func_191420_l(), this.field_145850_b, this.field_174879_c);
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new LockerContainer(windowId, playerInventory, this, this.field_174879_c, this.lockerID);
    }

    public ITextComponent func_145748_c_() {
        return this.lockerID != null && !this.lockerID.isEmpty() ? new StringTextComponent(this.lockerID) : new TranslationTextComponent("block.endermail.locker", new Object[0]);
    }

    public void func_145843_s() {
        super.func_145843_s();
        LockerWorldData data = LockerWorldData.get(this.field_145850_b);
        if (data != null) {
            data.removeLocker(this.lockerID);
        }
    }

    public boolean isFull() {
        for (ItemStack stack : this.contents) {
            if (!stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean addPackage(ItemStack stack) {
        for (int i = 0; i < this.contents.size(); ++i) {
            if (!((ItemStack)this.contents.get(i)).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            LockerBlock.setFilled(true, this.field_145850_b, this.field_174879_c);
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public void setLockerID(String lockerID) {
        LockerWorldData data = LockerWorldData.get(this.field_145850_b);
        if (data != null) {
            data.removeLocker(this.lockerID);
            this.lockerID = data.createLocker(lockerID, this.field_174879_c);
        }
    }

    public String getLockerID() {
        return this.lockerID;
    }
}

