/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FeatureMarblePile
extends Feature<NoFeatureConfig> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};

    public FeatureMarblePile(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i49873_1_) {
        super(p_i49873_1_);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if ((double)rand.nextFloat() > 0.2) {
            return false;
        }
        for (int i = 0; i < 4 + rand.nextInt(6); ++i) {
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(15), 64, rand.nextInt(15));
            if (!worldIn.func_180495_p((blockpos = new BlockPos(blockpos.func_177958_n(), worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, blockpos.func_177958_n(), blockpos.func_177952_p()), blockpos.func_177952_p())).func_177977_b()).func_200132_m()) continue;
            if (rand.nextInt(3) == 0) {
                int h;
                BlockPos height = new BlockPos((Vec3i)blockpos);
                worldIn.func_180501_a(height.func_177977_b(), RatsBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P(), 2);
                for (h = 0; h < 3 + rand.nextInt(3); ++h) {
                    worldIn.func_180501_a(height.func_177981_b(h), (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y), 2);
                }
                worldIn.func_180501_a(height.func_177981_b(h), RatsBlockRegistry.MARBLED_CHEESE_CHISELED.func_176223_P(), 2);
                worldIn.func_180501_a(height.func_177981_b(h + 1), RatsBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P(), 2);
                for (Direction facing : HORIZONTALS) {
                    BlockPos stairPos = height.func_177981_b(h + 1).func_177972_a(facing);
                    BlockState stairState = (BlockState)((BlockState)RatsBlockRegistry.MARBLED_CHEESE_STAIRS.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)facing.func_176734_d())).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)Half.TOP);
                    IFluidState ifluidstate = worldIn.func_204610_c(stairPos);
                    stairState = (BlockState)stairState.func_206870_a((IProperty)StairsBlock.field_204513_t, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
                    worldIn.func_180501_a(stairPos, stairState, 2);
                }
                continue;
            }
            if (rand.nextInt(2) == 0) {
                Direction randFacing = HORIZONTALS[rand.nextInt(HORIZONTALS.length - 1)];
                Direction.Axis axis = randFacing.func_176740_k();
                worldIn.func_180501_a(blockpos, (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis), 2);
                worldIn.func_180501_a(blockpos.func_177972_a(randFacing), (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis), 2);
                continue;
            }
            worldIn.func_180501_a(blockpos, (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.values()[rand.nextInt(Direction.Axis.values().length - 1)]), 2);
        }
        return true;
    }
}

