/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.pathfinding;

import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.pathfinding.AStar;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class AStarNode {
    private static final float H = 1.0f;
    public AStarNode start;
    protected double calcCost = -1.0;
    private AStar aStar;
    private BlockPos pos;
    private BlockPos end;
    private double baseCost;

    public AStarNode(AStar aStar, AStarNode start, BlockPos pos, double cost, BlockPos end) {
        this.aStar = aStar;
        this.start = start;
        this.pos = pos;
        this.baseCost = cost;
        this.end = end;
    }

    public double getCost() {
        if (this.calcCost == -1.0) {
            this.calcCost = this.pos.func_177951_i((Vec3i)this.end);
        }
        return this.baseCost + 1.0 * this.calcCost;
    }

    public void generateReachablePos(IWorldReader world) {
        boolean flag = false;
        for (Direction facing : Direction.values()) {
            BlockPos offset = this.pos.func_177972_a(facing);
            if (AStar.isRatTube(world, offset) || world.func_180495_p(offset).func_177230_c() instanceof BlockRatCage) {
                this.travel(offset, this.baseCost + 1.0);
                flag = true;
                continue;
            }
            BlockPos offPos = AStar.getConnectedToRatTube((IBlockReader)world, offset);
            if (offPos == null) continue;
            this.travel(offPos, this.baseCost + 10.0);
            flag = true;
        }
        if (this.aStar.includeAir) {
            for (int i = -1; i < 1; ++i) {
                for (int j = -1; j < 1; ++j) {
                    for (int k = -1; k < 1; ++k) {
                        BlockPos offset = this.pos.func_177982_a(i, j, k);
                        if (!world.func_175623_d(offset) || !world.func_180495_p(offset.func_177977_b()).func_200132_m()) continue;
                        this.travel(offset, this.baseCost + 50.0);
                    }
                }
            }
        }
    }

    private void travel(BlockPos offset, double cost) {
        AStarNode nt = this.aStar.getNodeFromMap(offset);
        if (nt.start == null && nt != this.start) {
            nt.baseCost = cost;
            nt.start = this;
            this.aStar.shoppingList.add(nt);
            return;
        }
        if (nt.baseCost > cost) {
            nt.baseCost = cost;
            nt.start = this;
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

