/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCraftingTable;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageIncreaseRatRecipe {
    public long blockPos;
    public boolean increase;

    public MessageIncreaseRatRecipe(long blockPos, boolean increase) {
        this.blockPos = blockPos;
        this.increase = increase;
    }

    public static MessageIncreaseRatRecipe read(PacketBuffer buf) {
        return new MessageIncreaseRatRecipe(buf.readLong(), buf.readBoolean());
    }

    public static void write(MessageIncreaseRatRecipe message, PacketBuffer buf) {
        buf.writeLong(message.blockPos);
        buf.writeBoolean(message.increase);
    }

    public static class Handler {
        public static void handle(MessageIncreaseRatRecipe message, Supplier<NetworkEvent.Context> context) {
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (player != null && player.field_70170_p.func_175625_s(pos = BlockPos.func_218283_e((long)message.blockPos)) instanceof TileEntityRatCraftingTable) {
                TileEntityRatCraftingTable table = (TileEntityRatCraftingTable)player.field_70170_p.func_175625_s(pos);
                if (message.increase) {
                    table.increaseRecipe();
                } else {
                    table.decreaseRecipe();
                }
            }
        }
    }
}

