/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RatAIPickupFluid
extends Goal {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private BlockPos targetBlock = null;
    private int feedingTicks;

    public RatAIPickupFluid(EntityRat entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.canPickUp() && this.entity.func_70638_az() == null && this.entity.getMBTransferRate() != 0)) {
            return false;
        }
        if (!this.entity.transportingFluid.isEmpty() && this.entity.transportingFluid.getAmount() >= this.entity.getMBTransferRate()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.pickupPos;
    }

    private boolean canPickUp() {
        return this.entity.getCommand() == RatCommand.TRANSPORT || this.entity.getCommand() == RatCommand.HARVEST && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER);
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && (this.entity.transportingFluid.isEmpty() || this.entity.transportingFluid.getAmount() < this.entity.getMBTransferRate());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false, (Entity)this.entity);
        if (rayTrace instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity entity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25);
            double distance = this.entity.func_70092_e((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
            if (distance <= (double)2.89f * this.entity.getRatDistanceModifier() && this.canSeeChest()) {
                LazyOptional handler = entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN);
                if (handler.orElse(null) == null) {
                    return;
                }
                int currentAmount = 0;
                if (!this.entity.transportingFluid.isEmpty()) {
                    currentAmount = this.entity.transportingFluid.getAmount();
                }
                int howMuchWeWant = this.entity.getMBTransferRate() - currentAmount;
                FluidStack drainedStack = null;
                try {
                    if (((IFluidHandler)handler.orElse(null)).getTanks() > 0) {
                        FluidStack firstTank = ((IFluidHandler)handler.orElse(null)).getFluidInTank(0);
                        if (((IFluidHandler)handler.orElse(null)).getTanks() > 1) {
                            for (int i = 0; i < ((IFluidHandler)handler.orElse(null)).getTanks(); ++i) {
                                FluidStack otherTank = ((IFluidHandler)handler.orElse(null)).getFluidInTank(i);
                                if (this.entity.transportingFluid.isEmpty() || !this.entity.transportingFluid.isFluidEqual(otherTank)) continue;
                                firstTank = otherTank;
                            }
                        }
                        if (firstTank.isEmpty() && (this.entity.transportingFluid.isEmpty() || this.entity.transportingFluid.isFluidEqual(firstTank))) {
                            howMuchWeWant = Math.min(firstTank.getAmount(), howMuchWeWant);
                            if (((IFluidHandler)handler.orElse(null)).drain(howMuchWeWant, IFluidHandler.FluidAction.SIMULATE) != null) {
                                drainedStack = ((IFluidHandler)handler.orElse(null)).drain(howMuchWeWant, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                }
                catch (Exception firstTank) {
                    // empty catch block
                }
                if (drainedStack == null) {
                    this.targetBlock = null;
                    this.func_75251_c();
                } else {
                    if (this.entity.transportingFluid.isEmpty()) {
                        this.entity.transportingFluid = drainedStack.copy();
                    } else {
                        this.entity.transportingFluid.setAmount(this.entity.transportingFluid.getAmount() + Math.max(drainedStack.getAmount(), 0));
                    }
                    if (!this.entity.field_70170_p.field_72995_K) {
                        RatsMod.sendMSGToAll(new MessageUpdateRatFluid(this.entity.func_145782_y(), this.entity.transportingFluid));
                    }
                    SoundEvent sound = this.entity.transportingFluid.isEmpty() ? SoundEvents.field_187630_M : SoundEvents.field_187630_M;
                    this.entity.func_184185_a(sound, 1.0f, 1.0f);
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }
}

