/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsFluidRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class RatAIHarvestMilk
extends Goal {
    private final EntityRat entity;
    private Entity targetCow = null;
    private boolean reachedCow = false;
    private int fishingCooldown = 1000;
    private int throwCooldown = 0;
    private Random rand = new Random();
    private Predicate<LivingEntity> COW_PREDICATE = new com.google.common.base.Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity != null && RatUtils.isCow((Entity)entity) && !entity.func_70631_g_();
        }
    };

    public RatAIHarvestMilk(EntityRat entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER)) {
            return false;
        }
        if (!this.entity.transportingFluid.isEmpty() && this.entity.transportingFluid.getAmount() >= this.entity.getMBTransferRate()) {
            return false;
        }
        this.resetTarget();
        return this.targetCow != null;
    }

    public boolean func_75253_b() {
        return this.targetCow != null && (this.entity.transportingFluid.isEmpty() || this.entity.transportingFluid.getAmount() < this.entity.getMBTransferRate());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetCow != null && this.targetCow.func_70089_S() && (this.entity.transportingFluid.isEmpty() || this.entity.transportingFluid.getAmount() < this.entity.getMBTransferRate())) {
            this.entity.func_70661_as().func_75497_a(this.targetCow, 1.25);
            if ((double)this.entity.func_70032_d(this.targetCow) < 1.5 * this.entity.getRatDistanceModifier() && this.entity.transportingFluid.isEmpty()) {
                FluidBucketWrapper milkWrapper = new FluidBucketWrapper(new ItemStack((IItemProvider)Items.field_151117_aB));
                FluidStack milkFluid = new FluidStack(milkWrapper.getFluid(), 1000);
                if (milkFluid.isEmpty()) {
                    milkFluid = new FluidStack(RatsFluidRegistry.MILK_FLUID, 1000);
                }
                if (milkWrapper.getFluid() != null && (this.entity.transportingFluid.isEmpty() || this.entity.transportingFluid.getAmount() < this.entity.getMBTransferRate())) {
                    this.entity.transportingFluid = milkFluid.copy();
                    if (!this.entity.field_70170_p.field_72995_K) {
                        RatsMod.sendMSGToAll(new MessageUpdateRatFluid(this.entity.func_145782_y(), this.entity.transportingFluid));
                    }
                    this.entity.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                    this.targetCow = null;
                    this.func_75251_c();
                }
            }
        } else {
            this.func_75251_c();
        }
    }

    private void resetTarget() {
        int radius = this.entity.getSearchRadius();
        AxisAlignedBB bb = new AxisAlignedBB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).func_186670_a(this.entity.getSearchCenter());
        List list = this.entity.field_70170_p.func_175647_a(LivingEntity.class, bb, (Predicate)((com.google.common.base.Predicate)this.COW_PREDICATE));
        LivingEntity closestCow = null;
        for (LivingEntity base : list) {
            if (closestCow != null && !(base.func_70068_e((Entity)this.entity) < closestCow.func_70068_e((Entity)this.entity))) continue;
            closestCow = base;
        }
        if (closestCow != null) {
            this.targetCow = closestCow;
        }
    }
}

