/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class LayerRatPlague
extends LayerRenderer<EntityRat, SegmentedModel<EntityRat>> {
    private static final RenderType TEXTURE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_plague_overlay.png"));
    private static final RenderType TEXTURE_LUMBERJACK = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_lumberjack_upgrade.png"));
    private static final RenderType TEXTURE_TOGA = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/toga.png"));
    private static final RenderType TEXTURE_RATINATOR = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_ratinator_upgrade.png"));
    private static final ResourceLocation TEXTURE_PSYCHIC = new ResourceLocation("rats:textures/entity/ratlantis/psychic.png");
    private ResourceLocation TEXTURE_GHOST = new ResourceLocation("rats:textures/entity/ratlantis/ghost_pirat_overlay.png");
    private static final ModelRat RAT_MODEL = new ModelRat(0.5f);
    private final IEntityRenderer<EntityRat, SegmentedModel<EntityRat>> ratRenderer;

    public LayerRatPlague(IEntityRenderer<EntityRat, SegmentedModel<EntityRat>> ratRendererIn) {
        super(ratRendererIn);
        this.ratRenderer = ratRendererIn;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityRat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IVertexBuilder ivertexbuilder;
        IVertexBuilder ivertexbuilder2;
        if (!(this.ratRenderer.func_217764_d() instanceof ModelRat)) {
            return;
        }
        if (rat.hasPlague()) {
            ivertexbuilder2 = bufferIn.getBuffer(TEXTURE);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY) && rat.getHeldRF() > 0) {
            float f = (float)rat.field_70173_aa + partialTicks;
            ivertexbuilder = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)TEXTURE_PSYCHIC, (float)(f * 0.01f), (float)(f * 0.01f)));
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225597_a_((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
            ivertexbuilder2 = bufferIn.getBuffer(TEXTURE_RATINATOR);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            ivertexbuilder2 = bufferIn.getBuffer(TEXTURE_LUMBERJACK);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasToga()) {
            ivertexbuilder2 = bufferIn.getBuffer(TEXTURE_TOGA);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            float f = (float)rat.field_70173_aa + partialTicks;
            ivertexbuilder = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.TEXTURE_GHOST, (float)(f * 0.01f), (float)(f * 0.01f)));
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225597_a_((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    public boolean shouldCombineTextures() {
        return false;
    }
}

