/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendColorMapPacket {
    private Map<ResourceLocation, Integer> colorMap;

    public SendColorMapPacket(Map<ResourceLocation, Integer> c) {
        this.colorMap = c;
    }

    SendColorMapPacket(PacketBuffer buf) {
        int s = buf.func_150792_a();
        this.colorMap = new HashMap<ResourceLocation, Integer>(s);
        for (int i = 0; i < s; ++i) {
            ResourceLocation rl = buf.func_192575_l();
            int c = buf.readInt();
            this.colorMap.put(rl, c);
        }
    }

    void write(PacketBuffer buf) {
        buf.func_150787_b(this.colorMap.size());
        for (Map.Entry<ResourceLocation, Integer> entry : this.colorMap.entrySet()) {
            buf.func_192572_a(entry.getKey());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> FTBChunks.instance.proxy.setColorMap(this.colorMap));
        context.get().setPacketHandled(true);
    }
}

