/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResult;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkPlayerData;
import com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI;
import com.feed_the_beast.mods.ftbchunks.net.SendMapDataPacket;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class RequestChunkChangePacket {
    private int action;
    private Set<ChunkPos> chunks;

    public RequestChunkChangePacket(int a, Set<ChunkPos> c) {
        this.action = a;
        this.chunks = c;
    }

    RequestChunkChangePacket(PacketBuffer buf) {
        this.action = buf.func_150792_a();
        int s = buf.func_150792_a();
        this.chunks = new LinkedHashSet<ChunkPos>(s);
        for (int i = 0; i < s; ++i) {
            int x = buf.func_150792_a();
            int z = buf.func_150792_a();
            this.chunks.add(new ChunkPos(x, z));
        }
    }

    void write(PacketBuffer buf) {
        buf.func_150787_b(this.action);
        buf.func_150787_b(this.chunks.size());
        for (ChunkPos pos : this.chunks) {
            buf.func_150787_b(pos.field_77276_a);
            buf.func_150787_b(pos.field_77275_b);
        }
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Consumer<ChunkPos> consumer;
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            CommandSource source = player.func_195051_bN();
            ClaimedChunkPlayerData data = FTBChunksAPI.INSTANCE.getManager().getData(player);
            Instant time = Instant.now();
            switch (this.action) {
                case 0: {
                    consumer = pos -> {
                        ClaimResult result = data.claim(source, new ChunkDimPos(player.field_71093_bK, (ChunkPos)pos), false);
                        if (result.isSuccess()) {
                            result.setClaimedTime(time);
                        }
                    };
                    break;
                }
                case 1: {
                    consumer = pos -> data.unclaim(source, new ChunkDimPos(player.field_71093_bK, (ChunkPos)pos), false);
                    break;
                }
                case 2: {
                    consumer = pos -> {
                        ClaimResult result = data.load(source, new ChunkDimPos(player.field_71093_bK, (ChunkPos)pos), false);
                        if (result.isSuccess()) {
                            result.setForceLoadedTime(time);
                        }
                    };
                    break;
                }
                case 3: {
                    consumer = pos -> data.unload(source, new ChunkDimPos(player.field_71093_bK, (ChunkPos)pos), false);
                    break;
                }
                default: {
                    FTBChunks.LOGGER.warn("Unknown chunk action ID: " + this.action);
                    return;
                }
            }
            this.chunks.forEach(consumer);
            SendMapDataPacket.send(player);
        });
        context.get().setPacketHandled(true);
    }
}

