/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.net.NetClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.net.NetClaimedChunkGroup;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class NetClaimedChunkData {
    public int claimed;
    public int loaded;
    public int maxClaimed;
    public int maxLoaded;
    public List<NetClaimedChunkGroup> groups;
    public List<NetClaimedChunk> chunks;

    void read(PacketBuffer buf) {
        long currentTime = new Date().getTime();
        this.claimed = buf.func_150792_a();
        this.loaded = buf.func_150792_a();
        this.maxClaimed = buf.func_150792_a();
        this.maxLoaded = buf.func_150792_a();
        int gs = buf.func_150792_a();
        this.groups = new ArrayList<NetClaimedChunkGroup>(gs);
        int i = 0;
        while (i < gs) {
            NetClaimedChunkGroup g = new NetClaimedChunkGroup();
            g.id = i++;
            g.color = buf.readInt();
            g.forceLoaded = buf.readBoolean();
            g.owner = buf.func_179258_d();
            this.groups.add(g);
        }
        int cs = buf.func_150792_a();
        this.chunks = new ArrayList<NetClaimedChunk>(cs);
        for (int i2 = 0; i2 < cs; ++i2) {
            NetClaimedChunk c = new NetClaimedChunk();
            c.x = buf.func_150792_a();
            c.z = buf.func_150792_a();
            c.borders = buf.readUnsignedByte();
            c.group = this.groups.get(buf.func_150792_a());
            c.relativeTimeClaimed = buf.func_179260_f();
            c.relativeTimeForceLoaded = buf.func_179260_f();
            c.claimedDate = new Date(currentTime - c.relativeTimeClaimed);
            if (c.relativeTimeForceLoaded > 0L) {
                c.forceLoadedDate = new Date(currentTime - c.relativeTimeForceLoaded);
            }
            this.chunks.add(c);
        }
    }

    void write(PacketBuffer buf) {
        buf.func_150787_b(this.claimed);
        buf.func_150787_b(this.loaded);
        buf.func_150787_b(this.maxClaimed);
        buf.func_150787_b(this.maxLoaded);
        buf.func_150787_b(this.groups.size());
        for (NetClaimedChunkGroup g : this.groups) {
            buf.writeInt(g.color);
            buf.writeBoolean(g.forceLoaded);
            buf.func_179256_a(g.owner);
        }
        buf.func_150787_b(this.chunks.size());
        for (NetClaimedChunk c : this.chunks) {
            buf.func_150787_b(c.x);
            buf.func_150787_b(c.z);
            buf.writeByte(c.borders);
            buf.func_150787_b(c.group.id);
            buf.func_179254_b(c.relativeTimeClaimed);
            buf.func_179254_b(c.relativeTimeForceLoaded);
        }
    }
}

