/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.FTBChunksConfig;
import com.feed_the_beast.mods.ftbchunks.FTBTeamsIntegration;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResult;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResults;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkEvent;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkGroup;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkManager;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkPlayerData;
import com.feed_the_beast.mods.ftbchunks.impl.AllyMode;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkGroupImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.Color;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class ClaimedChunkPlayerDataImpl
implements ClaimedChunkPlayerData {
    public final ClaimedChunkManagerImpl manager;
    public final File file;
    public boolean shouldSave;
    public GameProfile profile;
    public int color;
    private final Map<String, ClaimedChunkGroupImpl> groups;
    public final Set<UUID> allies;
    public boolean alliesWhitelist;

    public ClaimedChunkPlayerDataImpl(ClaimedChunkManagerImpl m, File f, UUID id) {
        this.manager = m;
        this.file = f;
        this.shouldSave = false;
        this.profile = new GameProfile(id, "");
        this.color = 0;
        this.groups = new HashMap<String, ClaimedChunkGroupImpl>();
        this.allies = new HashSet<UUID>();
        this.alliesWhitelist = true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ClaimedChunkManager getManager() {
        return this.manager;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public int getColor() {
        if (this.color == 0) {
            this.color = Color.HSBtoRGB(MathUtils.RAND.nextFloat(), 0.65f, 1.0f);
            this.save();
        }
        return 0xFF000000 | this.color;
    }

    @Override
    public Collection<ClaimedChunk> getClaimedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunkImpl chunk : this.manager.claimedChunks.values()) {
            if (chunk.playerData != this) continue;
            list.add(chunk);
        }
        return list;
    }

    @Override
    public Collection<ClaimedChunk> getForceLoadedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunkImpl chunk : this.manager.claimedChunks.values()) {
            if (chunk.playerData != this || !chunk.isForceLoaded()) continue;
            list.add(chunk);
        }
        return list;
    }

    @Override
    public ClaimedChunkGroupImpl getGroup(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Invalid group ID!");
        }
        ClaimedChunkGroupImpl group = this.groups.get(id);
        if (group == null) {
            group = new ClaimedChunkGroupImpl(this, id);
            this.groups.put(id, group);
            this.save();
        }
        return group;
    }

    @Override
    public boolean hasGroup(String id) {
        return this.groups.containsKey(id);
    }

    @Override
    @Nullable
    public ClaimedChunkGroupImpl removeGroup(String id) {
        ClaimedChunkGroupImpl g = this.groups.remove(id);
        if (g != null) {
            this.save();
        }
        return g;
    }

    @Override
    public Collection<ClaimedChunkGroup> getGroups() {
        return this.groups.values();
    }

    @Override
    public ClaimResult claim(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk != null) {
            return ClaimResults.ALREADY_CLAIMED;
        }
        if (source.func_197022_f() instanceof ServerPlayerEntity && this.getClaimedChunks().size() >= FTBChunksConfig.getMaxClaimedChunks((ServerPlayerEntity)source.func_197022_f())) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunkImpl(this, pos);
        ClaimResult r = new ClaimedChunkEvent.Claim.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        this.manager.claimedChunks.put(pos, chunk);
        new ClaimedChunkEvent.Claim.Done(source, chunk).postAndGetResult();
        this.save();
        return chunk;
    }

    @Override
    public ClaimResult unclaim(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.playerData == this || source.func_197034_c(2) || source.func_197028_i().func_71264_H() || this.isTeamMember(source.func_197022_f()))) {
            return ClaimResults.NOT_OWNER;
        }
        ClaimResult r = new ClaimedChunkEvent.Unclaim.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        if (chunk.isForceLoaded()) {
            chunk.setForceLoadedTime(null);
            chunk.postSetForceLoaded(false);
            new ClaimedChunkEvent.Unload.Done(source, chunk).postAndGetResult();
        }
        this.manager.claimedChunks.remove(pos);
        new ClaimedChunkEvent.Unclaim.Done(source, chunk).postAndGetResult();
        chunk.playerData.save();
        return chunk;
    }

    @Override
    public ClaimResult load(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.playerData != this && !source.func_197034_c(2) && !source.func_197028_i().func_71264_H()) {
            return ClaimResults.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResults.ALREADY_LOADED;
        }
        if (source.func_197022_f() instanceof ServerPlayerEntity && this.getForceLoadedChunks().size() >= FTBChunksConfig.getMaxForceLoadedChunks((ServerPlayerEntity)source.func_197022_f())) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        ClaimResult r = new ClaimedChunkEvent.Load.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(Instant.now());
        chunk.postSetForceLoaded(true);
        new ClaimedChunkEvent.Load.Done(source, chunk).postAndGetResult();
        chunk.playerData.save();
        return chunk;
    }

    @Override
    public ClaimResult unload(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.playerData == this || source.func_197034_c(2) || source.func_197028_i().func_71264_H() || this.isTeamMember(source.func_197022_f()))) {
            return ClaimResults.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResults.NOT_LOADED;
        }
        ClaimResult r = new ClaimedChunkEvent.Unload.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(null);
        chunk.postSetForceLoaded(false);
        new ClaimedChunkEvent.Unload.Done(source, chunk).postAndGetResult();
        chunk.playerData.save();
        return chunk;
    }

    @Override
    public void save() {
        this.shouldSave = true;
    }

    public boolean isTeamMember(@Nullable Entity entity) {
        return entity instanceof ServerPlayerEntity && FTBChunks.teamsMod && FTBTeamsIntegration.isTeamMember(this, (ServerPlayerEntity)entity);
    }

    @Override
    public boolean isAlly(ServerPlayerEntity player) {
        if (FTBChunksConfig.allyMode == AllyMode.FORCED_ALL) {
            return true;
        }
        if (FTBChunksConfig.allyMode == AllyMode.FORCED_NONE) {
            return false;
        }
        return this.getUuid().equals(player.func_110124_au()) || this.getName().equals(player.func_146103_bH().getName()) || this.alliesWhitelist == this.allies.contains(player.func_110124_au()) || this.isTeamMember((Entity)player);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("uuid", UUIDTypeAdapter.fromUUID((UUID)this.getUuid()));
        json.addProperty("name", this.getName());
        json.addProperty("color", String.format("#%06X", 0xFFFFFF & this.color));
        JsonObject groupJson = new JsonObject();
        for (ClaimedChunkGroupImpl claimedChunkGroupImpl : this.groups.values()) {
            groupJson.add(claimedChunkGroupImpl.getId(), (JsonElement)claimedChunkGroupImpl.toJson());
        }
        json.add("groups", (JsonElement)groupJson);
        JsonArray alliesJson = new JsonArray();
        for (UUID ally : this.allies) {
            alliesJson.add(UUIDTypeAdapter.fromUUID((UUID)ally));
        }
        json.add("allies", (JsonElement)alliesJson);
        json.addProperty("allies_whitelist", Boolean.valueOf(this.alliesWhitelist));
        JsonObject jsonObject = new JsonObject();
        for (ClaimedChunk chunk : this.getClaimedChunks()) {
            String dim = DimensionType.func_212678_a((DimensionType)chunk.getPos().dimension).toString();
            JsonElement e = jsonObject.get(dim);
            if (e == null || e.isJsonNull()) {
                e = new JsonArray();
                jsonObject.add(dim, e);
            }
            JsonObject chunkJson = new JsonObject();
            chunkJson.addProperty("x", (Number)chunk.getPos().x);
            chunkJson.addProperty("z", (Number)chunk.getPos().z);
            chunkJson.addProperty("time", chunk.getTimeClaimed().toString());
            if (chunk.isForceLoaded()) {
                chunkJson.addProperty("force_loaded", chunk.getForceLoadedTime().toString());
            }
            if (chunk.getGroup() != null) {
                chunkJson.addProperty("group", chunk.getGroup().getId());
            }
            e.getAsJsonArray().add((JsonElement)chunkJson);
        }
        json.add("chunks", (JsonElement)jsonObject);
        return json;
    }

    public void fromJson(JsonObject json) {
        this.profile = new GameProfile(this.getUuid(), json.get("name").getAsString());
        this.color = 0;
        try {
            this.color = Integer.decode(json.get("color").getAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (json.has("groups")) {
            for (Map.Entry entry : json.get("groups").getAsJsonObject().entrySet()) {
                this.getGroup((String)entry.getKey()).fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
            }
        }
        if (json.has("allies")) {
            for (JsonElement e : json.get("allies").getAsJsonArray()) {
                this.allies.add(UUIDTypeAdapter.fromString((String)e.getAsString()));
            }
        }
        if (json.has("allies_whitelist")) {
            this.alliesWhitelist = json.get("allies_whitelist").getAsBoolean();
        } else {
            this.alliesWhitelist = true;
            this.save();
        }
        if (json.has("chunks")) {
            for (Map.Entry entry : json.get("chunks").getAsJsonObject().entrySet()) {
                DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation((String)entry.getKey()));
                if (dimension == null) continue;
                for (JsonElement e : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    JsonObject o = e.getAsJsonObject();
                    int x = o.get("x").getAsInt();
                    int z = o.get("z").getAsInt();
                    ClaimedChunkImpl chunk = new ClaimedChunkImpl(this, new ChunkDimPos(dimension, x, z));
                    if (o.has("time")) {
                        chunk.time = Instant.parse(o.get("time").getAsString());
                    }
                    if (o.has("force_loaded")) {
                        if (o.get("force_loaded").getAsJsonPrimitive().isBoolean()) {
                            chunk.forceLoaded = chunk.time;
                            this.save();
                        } else {
                            chunk.forceLoaded = Instant.parse(o.get("force_loaded").getAsString());
                        }
                    }
                    if (o.has("group")) {
                        chunk.group = this.getGroup(o.get("group").getAsString());
                    }
                    this.manager.claimedChunks.put(chunk.pos, chunk);
                }
            }
        }
    }

    @Override
    public ITextComponent getDisplayName() {
        ITextComponent component;
        if (FTBChunks.teamsMod && (component = FTBTeamsIntegration.getTeamName(this)) != null) {
            return component;
        }
        return new StringTextComponent(this.getName());
    }
}

