/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClient;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.PixelBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import org.lwjgl.opengl.GL11;

public class ThreadReloadChunkSelector
extends Thread {
    private static ByteBuffer pixelBuffer = null;
    private static final int PIXEL_SIZE = 256;
    private static final PixelBuffer PIXELS = new PixelBuffer(256, 256);
    private static final BlockPos.Mutable CURRENT_BLOCK_POS = new BlockPos.Mutable(0, 0, 0);
    private static World world = null;
    private static ThreadReloadChunkSelector instance;
    private static int textureID;
    private static final int[] HEIGHT_MAP;
    private final int startX;
    private final int startZ;
    private boolean cancelled = false;

    static int getTextureId() {
        if (textureID == -1) {
            textureID = TextureUtil.func_225678_a_();
        }
        return textureID;
    }

    static void updateTexture() {
        if (pixelBuffer != null) {
            RenderSystem.bindTexture((int)ThreadReloadChunkSelector.getTextureId());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
            pixelBuffer = null;
        }
    }

    static void reloadArea(World w, int sx, int sz) {
        if (instance != null) {
            ThreadReloadChunkSelector.instance.cancelled = true;
            instance = null;
        }
        instance = new ThreadReloadChunkSelector(w, sx, sz);
        ThreadReloadChunkSelector.instance.cancelled = false;
        instance.start();
    }

    private ThreadReloadChunkSelector(World w, int sx, int sz) {
        super("ChunkSelectorAreaReloader");
        this.setDaemon(true);
        world = w;
        this.startX = sx;
        this.startZ = sz;
    }

    private static int getHeight(int x, int z) {
        int index = x + z * 256;
        return index < 0 || index >= HEIGHT_MAP.length ? -1 : HEIGHT_MAP[index];
    }

    @Override
    public void run() {
        Arrays.fill(PIXELS.getPixels(), -16777216);
        Arrays.fill(HEIGHT_MAP, -1);
        pixelBuffer = PIXELS.toByteBuffer(false);
        int startY = Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o();
        try {
            BlockState state;
            int by;
            int wz;
            int wx;
            int wi;
            int z;
            int x;
            Chunk chunk;
            int cz;
            int cx;
            ChunkPos pos;
            World w;
            int index;
            for (index = 0; index < 226 && (w = world) != null; ++index) {
                pos = MathUtils.getSpiralPoint((int)index);
                cx = pos.field_77276_a + 7;
                cz = pos.field_77275_b + 7;
                chunk = w.func_72863_F().func_217205_a(this.startX + cx, this.startZ + cz, false);
                if (chunk == null) continue;
                x = this.startX + cx << 4;
                z = this.startZ + cz << 4;
                int topY = w.func_201675_m().func_186058_p() == DimensionType.field_223228_b_ ? startY + 5 : Math.max(w.func_72940_L(), chunk.func_76625_h() + 15);
                block3: for (wi = 0; wi < 256; ++wi) {
                    wx = wi % 16;
                    wz = wi / 16;
                    for (by = topY; by > 0; --by) {
                        if (this.cancelled) {
                            return;
                        }
                        CURRENT_BLOCK_POS.func_181079_c(x + wx, by, z + wz);
                        state = chunk.func_180495_p((BlockPos)CURRENT_BLOCK_POS);
                        if (state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_196804_gh || state.func_177230_c().isAir(state, (IBlockReader)w, (BlockPos)CURRENT_BLOCK_POS)) continue;
                        ThreadReloadChunkSelector.HEIGHT_MAP[cx * 16 + wx + (cz * 16 + wz) * 256] = by;
                        continue block3;
                    }
                }
            }
            for (index = 0; index < 226 && (w = world) != null; ++index) {
                pos = MathUtils.getSpiralPoint((int)index);
                cx = pos.field_77276_a + 7;
                cz = pos.field_77275_b + 7;
                chunk = w.func_72863_F().func_217205_a(this.startX + cx, this.startZ + cz, false);
                if (chunk == null) continue;
                x = this.startX + cx << 4;
                z = this.startZ + cz << 4;
                for (wi = 0; wi < 256; ++wi) {
                    wx = wi % 16;
                    wz = wi / 16;
                    by = ThreadReloadChunkSelector.getHeight(cx * 16 + wx, cz * 16 + wz);
                    if (by < 0) continue;
                    CURRENT_BLOCK_POS.func_181079_c(x + wx, by, z + wz);
                    state = chunk.func_180495_p((BlockPos)CURRENT_BLOCK_POS);
                    Color4I color = FTBChunksClient.COLOR_MAP.get(state.func_177230_c());
                    if (color == null) {
                        color = Color4I.rgb((int)state.func_185909_g((IBlockReader)ThreadReloadChunkSelector.world, (BlockPos)ThreadReloadChunkSelector.CURRENT_BLOCK_POS).field_76291_p);
                    }
                    int bn = ThreadReloadChunkSelector.getHeight(cx * 16 + wx, cz * 16 + wz - 1);
                    int bw = ThreadReloadChunkSelector.getHeight(cx * 16 + wx - 1, cz * 16 + wz);
                    if (by > bn && bn != -1 || by > bw && bw != -1) {
                        color = color.addBrightness(0.1f);
                    }
                    if (by < bn && bn != -1 || by < bw && bw != -1) {
                        color = color.addBrightness(-0.1f);
                    }
                    PIXELS.setRGB(cx * 16 + wx, cz * 16 + wz, color.addBrightness(MathUtils.RAND.nextFloat() * 0.04f).rgba());
                }
                pixelBuffer = PIXELS.toByteBuffer(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        pixelBuffer = PIXELS.toByteBuffer(false);
        world = null;
        instance = null;
    }

    static {
        textureID = -1;
        HEIGHT_MAP = new int[65536];
    }
}

