/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.RequestAllyStatusChangePacket;
import com.feed_the_beast.mods.ftbchunks.net.SendPlayerListPacket;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class PlayerListScreen
extends GuiButtonListBase {
    public final List<SendPlayerListPacket.NetPlayer> players;
    public final int allyMode;

    public PlayerListScreen(List<SendPlayerListPacket.NetPlayer> p, int a) {
        this.players = p;
        this.allyMode = a;
        switch (this.allyMode) {
            case 0: {
                this.setTitle(I18n.func_135052_a((String)"ftbchunks.gui.ally_whitelist", (Object[])new Object[0]));
                break;
            }
            case 1: {
                this.setTitle(I18n.func_135052_a((String)"ftbchunks.gui.ally_blacklist", (Object[])new Object[0]));
                break;
            }
            case 2: {
                this.setTitle("Forced whitelist");
                break;
            }
            case 3: {
                this.setTitle("Forced blacklist");
            }
        }
    }

    public void addButtons(Panel panel) {
        for (final SendPlayerListPacket.NetPlayer p : this.players) {
            panel.add((Widget)new SimpleTextButton(panel, (p.isFake() ? TextFormatting.YELLOW : TextFormatting.WHITE) + p.name, p.isAlly() ? GuiIcons.REMOVE : GuiIcons.ADD){

                public void addMouseOverText(List<String> list) {
                    if (p.isFake()) {
                        list.add("Fake player");
                        list.add("UUID: " + p.uuid);
                    }
                }

                public WidgetType getWidgetType() {
                    if (p.isBanned()) {
                        return WidgetType.DISABLED;
                    }
                    return super.getWidgetType();
                }

                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    this.icon = this.icon == GuiIcons.ADD ? GuiIcons.REMOVE : GuiIcons.ADD;
                    FTBChunksNet.MAIN.sendToServer((Object)new RequestAllyStatusChangePacket(p.uuid));
                }
            });
        }
    }
}

