/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.client.ThreadReloadChunkSelector;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.NetClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.net.NetClaimedChunkData;
import com.feed_the_beast.mods.ftbchunks.net.NetClaimedChunkGroup;
import com.feed_the_beast.mods.ftbchunks.net.RequestChunkChangePacket;
import com.feed_the_beast.mods.ftbchunks.net.RequestMapDataPacket;
import com.feed_the_beast.mods.ftbchunks.net.RequestPlayerListPacket;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ImageIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ChunkScreen
extends GuiBase {
    private static final ImageIcon PLAYER_BACKGROUND = new ImageIcon(new ResourceLocation("ftbchunks", "textures/player_background.png"));
    public NetClaimedChunkData data;
    public List<ChunkButton> chunkButtons;
    public Set<ChunkPos> selectedChunks;

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        int startX = Minecraft.func_71410_x().field_71439_g.field_70176_ah - 7;
        int startZ = Minecraft.func_71410_x().field_71439_g.field_70164_aj - 7;
        ThreadReloadChunkSelector.reloadArea((World)Minecraft.func_71410_x().field_71441_e, startX, startZ);
        this.chunkButtons = new ArrayList<ChunkButton>();
        this.selectedChunks = new LinkedHashSet<ChunkPos>();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, new ChunkPos(startX + x, startZ + z));
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        FTBChunksNet.MAIN.sendToServer((Object)new RequestMapDataPacket());
        this.add(new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbchunks.gui.allies", (Object[])new Object[0]), GuiIcons.FRIENDS, (simpleButton, mouseButton) -> FTBChunksNet.MAIN.sendToServer((Object)new RequestPlayerListPacket())).setPosAndSize(2, 2, 16, 16));
    }

    public void setData(NetClaimedChunkData d) {
        int centerX = Minecraft.func_71410_x().field_71439_g.field_70176_ah;
        int centerZ = Minecraft.func_71410_x().field_71439_g.field_70164_aj;
        for (NetClaimedChunkGroup group : d.groups) {
            group.formattedOwner = new StringTextComponent("").func_211708_a(TextFormatting.AQUA).func_150257_a(group.owner).func_150254_d();
        }
        HashMap<ChunkPos, NetClaimedChunk> chunkMap = new HashMap<ChunkPos, NetClaimedChunk>();
        for (NetClaimedChunk chunk : d.chunks) {
            chunkMap.put(new ChunkPos(centerX + chunk.x, centerZ + chunk.z), chunk);
        }
        for (ChunkButton button : this.chunkButtons) {
            button.chunk = (NetClaimedChunk)chunkMap.get(new ChunkPos(button.chunkPos.field_77276_a, button.chunkPos.field_77275_b));
        }
        this.data = d;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            FTBChunksNet.MAIN.sendToServer((Object)new RequestChunkChangePacket(ChunkScreen.isShiftKeyDown() ? (button.isLeft() ? 2 : 3) : (button.isLeft() ? 0 : 1), this.selectedChunks));
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        GlStateManager.func_227621_I_();
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.5f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.rect(buffer, sx - 1, sy - 1, 242, 242, 0, 0, 0, 255);
        tessellator.func_78381_a();
        ThreadReloadChunkSelector.updateTexture();
        RenderSystem.enableTexture();
        GlStateManager.func_227760_t_((int)ThreadReloadChunkSelector.getTextureId());
        GuiHelper.drawTexturedRect((int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)0.9375f, (float)0.9375f);
        GlStateManager.func_227621_I_();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (int gy = 0; gy <= 15; ++gy) {
            buffer.func_225582_a_((double)sx, (double)(sy + gy * 16), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)(sx + 240), (double)(sy + gy * 16), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        }
        for (int gx = 0; gx <= 15; ++gx) {
            buffer.func_225582_a_((double)(sx + gx * 16), (double)sy, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)(sx + gx * 16), (double)(sy + 240), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        if (this.data != null && !this.data.chunks.isEmpty() && !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)258)) {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            boolean anyForceLoaded = false;
            for (NetClaimedChunk chunk : this.data.chunks) {
                int cr = chunk.group.color >> 16 & 0xFF;
                int cg = chunk.group.color >> 8 & 0xFF;
                int cb = chunk.group.color >> 0 & 0xFF;
                int cx = (7 + chunk.x) * 16;
                int cy = (7 + chunk.z) * 16;
                this.rect(buffer, sx + cx, sy + cy, 16, 16, cr, cg, cb, 100);
                if ((chunk.borders & 1) != 0) {
                    this.rect(buffer, sx + cx, sy + cy, 16, 1, cr, cg, cb, 255);
                }
                if ((chunk.borders & 2) != 0) {
                    this.rect(buffer, sx + cx, sy + cy + 16 - 1, 16, 1, cr, cg, cb, 255);
                }
                if ((chunk.borders & 4) != 0) {
                    this.rect(buffer, sx + cx, sy + cy, 1, 16, cr, cg, cb, 255);
                }
                if ((chunk.borders & 8) != 0) {
                    this.rect(buffer, sx + cx + 16 - 1, sy + cy, 1, 16, cr, cg, cb, 255);
                }
                if (!chunk.group.forceLoaded) continue;
                anyForceLoaded = true;
            }
            tessellator.func_78381_a();
            if (anyForceLoaded) {
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                for (NetClaimedChunk chunk : this.data.chunks) {
                    if (!chunk.group.forceLoaded) continue;
                    int cx = (7 + chunk.x) * 16;
                    int cy = (7 + chunk.z) * 16;
                    buffer.func_225582_a_((double)(sx + cx), (double)(sy + cy), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                    buffer.func_225582_a_((double)(sx + cx + 16), (double)(sy + cy + 16), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                    buffer.func_225582_a_((double)((float)(sx + cx) + 8.0f), (double)(sy + cy), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                    buffer.func_225582_a_((double)(sx + cx + 16), (double)((float)(sy + cy) + 8.0f), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                    buffer.func_225582_a_((double)(sx + cx), (double)((float)(sy + cy) + 8.0f), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                    buffer.func_225582_a_((double)((float)(sx + cx) + 8.0f), (double)(sy + cy + 16), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                }
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_227619_H_();
        GlStateManager.func_227701_d_((float)1.0f);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int cx = player.field_70176_ah;
        int cz = player.field_70164_aj;
        int startX = cx - 7;
        int startZ = cz - 7;
        if (cx >= startX && cz >= startZ && cx < startX + 240 && cz < startZ + 240) {
            double x1 = (double)(cx - startX) * 16.0 + MathUtils.mod((double)player.func_226277_ct_(), (double)16.0);
            double z1 = (double)(cz - startZ) * 16.0 + MathUtils.mod((double)player.func_226281_cx_(), (double)16.0);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)sx + x1 * 16.0 / 16.0), (double)((double)sy + z1 * 16.0 / 16.0), (double)0.0);
            RenderSystem.pushMatrix();
            RenderSystem.rotatef((float)(player.field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            PLAYER_BACKGROUND.draw(-8, -8, 16, 16);
            RenderSystem.popMatrix();
            GuiIcons.PLAYER.draw(-4, -4, 8, 8);
            RenderSystem.popMatrix();
        }
        if (this.data != null) {
            ArrayList<String> list = new ArrayList<String>(4);
            list.add(I18n.func_135052_a((String)"ftbchunks.gui.claimed", (Object[])new Object[0]));
            list.add((this.data.claimed > this.data.maxClaimed ? TextFormatting.RED : (this.data.claimed == this.data.maxClaimed ? TextFormatting.YELLOW : TextFormatting.GREEN)) + "" + this.data.claimed + " / " + this.data.maxClaimed);
            list.add(I18n.func_135052_a((String)"ftbchunks.gui.force_loaded", (Object[])new Object[0]));
            list.add((this.data.loaded > this.data.maxLoaded ? TextFormatting.RED : (this.data.loaded == this.data.maxLoaded ? TextFormatting.YELLOW : TextFormatting.GREEN)) + "" + this.data.loaded + " / " + this.data.maxLoaded);
            for (int i = 0; i < list.size(); ++i) {
                theme.drawString((String)list.get(i), 3.0f, (float)(this.getScreen().func_198087_p() - 10 * (list.size() - i) - 1), Color4I.WHITE, 2);
            }
        }
    }

    private void rect(BufferBuilder buffer, int x, int y, int w, int h, int r, int g, int b, int a) {
        buffer.func_225582_a_((double)x, (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public class ChunkButton
    extends Button {
        public final ChunkPos chunkPos;
        public NetClaimedChunk chunk;

        public ChunkButton(Panel panel, ChunkPos cp) {
            super(panel, "", (Icon)Icon.EMPTY);
            this.setSize(16, 16);
            this.chunkPos = cp;
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(List<String> list) {
            if (this.chunk != null) {
                list.add(this.chunk.group.formattedOwner);
                Date date = new Date();
                if (Screen.hasAltDown()) {
                    list.add(TextFormatting.GRAY + this.chunk.claimedDate.toLocaleString());
                } else {
                    list.add(TextFormatting.GRAY + ClaimedChunkManagerImpl.prettyTimeString((date.getTime() - this.chunk.claimedDate.getTime()) / 1000L) + " ago");
                }
                if (this.chunk.forceLoadedDate != null) {
                    list.add(TextFormatting.RED + I18n.func_135052_a((String)"ftbchunks.gui.force_loaded", (Object[])new Object[0]));
                    if (Screen.hasAltDown()) {
                        list.add(TextFormatting.GRAY + this.chunk.forceLoadedDate.toLocaleString());
                    } else {
                        list.add(TextFormatting.GRAY + ClaimedChunkManagerImpl.prettyTimeString((date.getTime() - this.chunk.forceLoadedDate.getTime()) / 1000L) + " ago");
                    }
                }
            }
        }
    }
}

