/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.api;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;

public class ChunkDimPos
implements Comparable<ChunkDimPos> {
    public final DimensionType dimension;
    public final int x;
    public final int z;
    private ChunkPos chunkPos;
    private int hash;

    public ChunkDimPos(DimensionType dim, int _x, int _z) {
        this.dimension = dim;
        this.x = _x;
        this.z = _z;
    }

    public ChunkDimPos(DimensionType dim, ChunkPos pos) {
        this(dim, pos.field_77276_a, pos.field_77275_b);
    }

    public ChunkDimPos(IWorld world, BlockPos pos) {
        this(world.func_201675_m().func_186058_p(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public ChunkDimPos(Entity entity) {
        this(entity.field_71093_bK, MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4);
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.x, this.z);
        }
        return this.chunkPos;
    }

    public String toString() {
        return "[" + DimensionType.func_212678_a((DimensionType)this.dimension) + ":" + this.x + ":" + this.z + "]";
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.dimension, this.x, this.z);
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChunkDimPos) {
            ChunkDimPos p = (ChunkDimPos)obj;
            return this.dimension == p.dimension && this.x == p.x && this.z == p.z;
        }
        return false;
    }

    @Override
    public int compareTo(ChunkDimPos o) {
        int i = this.dimension.getRegistryName().compareTo(o.dimension.getRegistryName());
        return i == 0 ? Long.compare(this.getChunkPos().func_201841_a(), o.getChunkPos().func_201841_a()) : i;
    }
}

