/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.FTBRanksIntegration;
import com.feed_the_beast.mods.ftbchunks.impl.AllyMode;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class FTBChunksConfig {
    public static boolean disableAllFakePlayers;
    public static int maxClaimedChunks;
    public static int maxForceLoadedChunks;
    public static AllyMode allyMode;
    private static Pair<ServerConfig, ForgeConfigSpec> server;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FTBChunksConfig::reload);
        server = new ForgeConfigSpec.Builder().configure(x$0 -> new ServerConfig((ForgeConfigSpec.Builder)x$0));
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)server.getRight());
    }

    public static void reload(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == server.getRight()) {
            ServerConfig c = (ServerConfig)server.getLeft();
            disableAllFakePlayers = (Boolean)c.disableAllFakePlayers.get();
            maxClaimedChunks = (Integer)c.maxClaimedChunks.get();
            maxForceLoadedChunks = (Integer)c.maxForceLoadedChunks.get();
            allyMode = (AllyMode)((Object)c.allyMode.get());
        }
    }

    public static int getMaxClaimedChunks(ServerPlayerEntity player) {
        if (FTBChunks.ranksMod) {
            return FTBRanksIntegration.getMaxClaimedChunks(player, maxClaimedChunks);
        }
        return maxClaimedChunks;
    }

    public static int getMaxForceLoadedChunks(ServerPlayerEntity player) {
        if (FTBChunks.ranksMod) {
            return FTBRanksIntegration.getMaxForceLoadedChunks(player, maxClaimedChunks);
        }
        return maxForceLoadedChunks;
    }

    private static class ServerConfig {
        private final ForgeConfigSpec.BooleanValue disableAllFakePlayers;
        private final ForgeConfigSpec.IntValue maxClaimedChunks;
        private final ForgeConfigSpec.IntValue maxForceLoadedChunks;
        private final ForgeConfigSpec.EnumValue<AllyMode> allyMode;

        private ServerConfig(ForgeConfigSpec.Builder builder) {
            this.disableAllFakePlayers = builder.comment("Disables fake players like miners and auto-clickers.").translation("ftbchunks.general.disable_fake_players").define("disable_fake_players", false);
            this.maxClaimedChunks = builder.comment("Max claimed chunks.").translation("ftbchunks.general.max_claimed_chunks").defineInRange("max_claimed_chunks", 500, 0, Integer.MAX_VALUE);
            this.maxForceLoadedChunks = builder.comment("Max force loaded chunks.").translation("ftbchunks.general.max_force_loaded_chunks").defineInRange("max_force_loaded_chunks", 25, 0, Integer.MAX_VALUE);
            this.allyMode = builder.comment("Forced modes won't let players change their ally settings.").translation("ftbchunks.general.ally_mode").defineEnum("ally_mode", (Enum)AllyMode.DEFAULT);
        }
    }
}

