/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResult;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkPlayerData;
import com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.util.UUIDTypeAdapter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class FTBChunksCommands {
    public FTBChunksCommands(FMLServerStartingEvent event) {
        LiteralCommandNode command = event.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbchunks").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").executes(context -> this.claim((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)30)).executes(context -> this.claim((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").executes(context -> this.unclaim((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)30)).executes(context -> this.unclaim((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"load").executes(context -> this.load((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)30)).executes(context -> this.load((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unload").executes(context -> this.unload((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)30)).executes(context -> this.unload((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim_all").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).requires(source -> source.func_197034_c(2))).executes(context -> this.unclaimAll((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"players"))))).executes(context -> this.unclaimAll((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h().func_146103_bH()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unload_all").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).requires(source -> source.func_197034_c(2))).executes(context -> this.unloadAll((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"players"))))).executes(context -> this.unloadAll((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h().func_146103_bH()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").executes(context -> this.info((CommandSource)context.getSource(), new ChunkDimPos(((CommandSource)context.getSource()).func_197023_e().field_73011_w.func_186058_p(), new ChunkPos(new BlockPos(((CommandSource)context.getSource()).func_197036_d())))))).then(Commands.func_197056_a((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.info((CommandSource)context.getSource(), new ChunkDimPos(((CommandSource)context.getSource()).func_197023_e().field_73011_w.func_186058_p(), IntegerArgumentType.getInteger((CommandContext)context, (String)"x") >> 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"z") >> 4)))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> this.info((CommandSource)context.getSource(), new ChunkDimPos(DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)context, (String)"x") >> 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"z") >> 4)))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"export").then(Commands.func_197057_a((String)"json").executes(context -> this.exportJson((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"svg").executes(context -> this.exportSvg((CommandSource)context.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"ally_whitelist").then(Commands.func_197057_a((String)"true").executes(context -> this.allyWhitelist((CommandSource)context.getSource(), true)))).then(Commands.func_197057_a((String)"false").executes(context -> this.allyWhitelist((CommandSource)context.getSource(), false)))));
        event.getCommandDispatcher().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunks").redirect((CommandNode)command));
    }

    private void forEachChunk(CommandSource source, int r, ChunkCallback callback) throws CommandSyntaxException {
        ClaimedChunkPlayerData data = FTBChunksAPI.INSTANCE.getManager().getData(source.func_197035_h());
        DimensionType type = source.func_197023_e().field_73011_w.func_186058_p();
        int ox = MathHelper.func_76128_c((double)source.func_197036_d().field_72450_a) >> 4;
        int oz = MathHelper.func_76128_c((double)source.func_197036_d().field_72449_c) >> 4;
        ArrayList<ChunkDimPos> list = new ArrayList<ChunkDimPos>();
        for (int z = -r; z <= r; ++z) {
            for (int x = -r; x <= r; ++x) {
                list.add(new ChunkDimPos(type, ox + x, oz + z));
            }
        }
        list.sort(Comparator.comparingDouble(o -> MathUtils.distSq((double)ox, (double)oz, (double)o.x, (double)o.z)));
        for (ChunkDimPos pos : list) {
            callback.accept(data, pos);
        }
    }

    private int claim(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        Instant time = Instant.now();
        this.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.claim(source, pos, false);
            if (result.isSuccess()) {
                result.setClaimedTime(time);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Claimed " + success[0] + " chunks!"), true);
        FTBChunks.LOGGER.info(source.func_197037_c() + " claimed " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private int unclaim(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        this.forEachChunk(source, r, (data, pos) -> {
            if (data.unclaim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Unclaimed " + success[0] + " chunks!"), true);
        FTBChunks.LOGGER.info(source.func_197037_c() + " unclaimed " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private int load(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        Instant time = Instant.now();
        this.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.load(source, pos, false);
            if (result.isSuccess()) {
                result.setForceLoadedTime(time);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Loaded " + success[0] + " chunks!"), true);
        FTBChunks.LOGGER.info(source.func_197037_c() + " loaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private int unload(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        this.forEachChunk(source, r, (data, pos) -> {
            if (data.unload(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Unloaded " + success[0] + " chunks!"), true);
        FTBChunks.LOGGER.info(source.func_197037_c() + " unloaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private int unclaimAll(CommandSource source, Collection<GameProfile> players) {
        for (GameProfile profile : players) {
            ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.playerData.get(profile.getId());
            if (data == null) continue;
            for (ClaimedChunk c : data.getClaimedChunks()) {
                data.unclaim(source, c.getPos(), false);
            }
            data.save();
        }
        return 1;
    }

    private int unloadAll(CommandSource source, Collection<GameProfile> players) {
        for (GameProfile profile : players) {
            ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.playerData.get(profile.getId());
            if (data == null) continue;
            for (ClaimedChunk c : data.getClaimedChunks()) {
                data.unload(source, c.getPos(), false);
            }
        }
        return 1;
    }

    private int info(CommandSource source, ChunkDimPos pos) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Location: " + pos), true);
        ClaimedChunkImpl chunk = FTBChunksAPIImpl.manager.getChunk(pos);
        if (chunk == null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Chunk not claimed!"), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Owner: " + chunk.getPlayerData().getName() + " / " + UUIDTypeAdapter.fromUUID((UUID)chunk.getPlayerData().getUuid())), true);
        if (source.func_197034_c(2)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Force Loaded: " + chunk.isForceLoaded()), true);
        }
        return 1;
    }

    private int exportJson(CommandSource source) {
        FTBChunksAPIImpl.manager.exportJson();
        source.func_197030_a((ITextComponent)new StringTextComponent("Exported FTB Chunks data to <world directory>/data/ftbchunks/export/all.json!"), true);
        return 1;
    }

    private int exportSvg(CommandSource source) {
        FTBChunksAPIImpl.manager.exportSvg();
        source.func_197030_a((ITextComponent)new StringTextComponent("Exported FTB Chunks data to <world directory>/data/ftbchunks/export/<dimension>.svg!"), true);
        return 1;
    }

    private int allyWhitelist(CommandSource source, boolean b) throws CommandSyntaxException {
        ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(source.func_197035_h());
        data.alliesWhitelist = b;
        data.save();
        source.func_197030_a((ITextComponent)new StringTextComponent("Changed ally mode to " + (b ? "whitelist" : "blacklist")), false);
        return 1;
    }

    private static interface ChunkCallback {
        public void accept(ClaimedChunkPlayerData var1, ChunkDimPos var2) throws CommandSyntaxException;
    }
}

