/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks;

import com.feed_the_beast.mods.ftbchunks.FTBChunksCommands;
import com.feed_the_beast.mods.ftbchunks.FTBChunksCommon;
import com.feed_the_beast.mods.ftbchunks.FTBChunksConfig;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI;
import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClient;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.KnownFakePlayer;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.SendColorMapPacket;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbchunks")
public class FTBChunks {
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static FTBChunks instance;
    public FTBChunksCommon proxy;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int GUI_SIZE = 240;
    public static final float UV = 0.9375f;
    public static boolean teamsMod;
    public static boolean ranksMod;

    public FTBChunks() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(FTBChunksCommands::new);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::worldSaved);
        MinecraftForge.EVENT_BUS.addListener(this::loggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::blockLeftClick);
        MinecraftForge.EVENT_BUS.addListener(this::blockRightClick);
        MinecraftForge.EVENT_BUS.addListener(this::itemRightClick);
        MinecraftForge.EVENT_BUS.addListener(this::blockBreak);
        MinecraftForge.EVENT_BUS.addListener(this::blockPlace);
        MinecraftForge.EVENT_BUS.addListener(this::fillBucket);
        MinecraftForge.EVENT_BUS.addListener(this::chunkChange);
        MinecraftForge.EVENT_BUS.addListener(this::mobSpawned);
        MinecraftForge.EVENT_BUS.addListener(this::explosionDetonate);
        this.proxy = (FTBChunksCommon)DistExecutor.runForDist(() -> () -> new FTBChunksClient(), () -> () -> new FTBChunksCommon());
        this.proxy.init();
        FTBChunksAPI.INSTANCE = new FTBChunksAPIImpl();
        FTBChunksConfig.init();
    }

    private void init(FMLCommonSetupEvent event) {
        FTBChunksNet.init();
        teamsMod = ModList.get().isLoaded("ftbteams");
        ranksMod = ModList.get().isLoaded("ftbranks");
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        FTBChunksAPIImpl.manager = new ClaimedChunkManagerImpl(event.getServer());
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new ReloadListener<JsonObject>(){

            protected JsonObject prepare(IResourceManager resourceManager, IProfiler profiler) {
                Gson gson = new GsonBuilder().setLenient().create();
                JsonObject object = new JsonObject();
                try {
                    for (IResource resource : resourceManager.func_199004_b(new ResourceLocation("ftbchunks", "ftbchunks_colors.json"))) {
                        try {
                            InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);
                            Throwable throwable = null;
                            try {
                                for (Map.Entry entry : ((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)).entrySet()) {
                                    object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return object;
            }

            protected void apply(JsonObject object, IResourceManager resourceManager, IProfiler profiler) {
                FTBChunksAPIImpl.COLOR_MAP.clear();
                FTBChunksAPIImpl.COLOR_MAP_NET.clear();
                for (Map.Entry entry : object.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)entry.getKey()));
                    Color4I color = Color4I.fromJson((JsonElement)((JsonElement)entry.getValue()));
                    if (block == Blocks.field_150350_a || color.isEmpty()) continue;
                    FTBChunksAPIImpl.COLOR_MAP.put(block, color);
                    FTBChunksAPIImpl.COLOR_MAP_NET.put(block.getRegistryName(), color.rgba());
                }
            }
        });
    }

    private void serverStarting(FMLServerStartingEvent event) {
        FTBChunksAPIImpl.manager.serverStarting();
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        FTBChunksAPIImpl.manager = null;
    }

    private void worldSaved(WorldEvent.Save event) {
        if (!event.getWorld().func_201670_d()) {
            FTBChunksAPIImpl.manager.serverSaved();
        }
    }

    private void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData((ServerPlayerEntity)event.getPlayer());
        if (!data.getName().equals(event.getPlayer().func_146103_bH().getName())) {
            data.profile = new GameProfile(data.getUuid(), event.getPlayer().func_146103_bH().getName());
            data.save();
        }
        FTBChunksNet.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SendColorMapPacket(FTBChunksAPIImpl.COLOR_MAP_NET));
    }

    private boolean isValidPlayer(@Nullable Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            if (entity instanceof FakePlayer) {
                if (FTBChunksConfig.disableAllFakePlayers) {
                    return false;
                }
                KnownFakePlayer player = FTBChunksAPIImpl.manager.knownFakePlayers.get(entity.func_110124_au());
                if (player == null) {
                    player = new KnownFakePlayer(entity.func_110124_au(), ((FakePlayer)entity).func_146103_bH().getName(), false);
                    FTBChunksAPIImpl.manager.knownFakePlayers.put(player.uuid, player);
                    FTBChunksAPIImpl.manager.saveFakePlayers = true;
                }
                return !player.banned;
            }
            return true;
        }
        return false;
    }

    private void blockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), event.getPos()))) != null && !chunk.canEdit((ServerPlayerEntity)event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    private void blockRightClick(PlayerInteractEvent.RightClickBlock event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), event.getPos()))) != null && !chunk.canInteract((ServerPlayerEntity)event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    private void itemRightClick(PlayerInteractEvent.RightClickItem event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && !event.getItemStack().func_222117_E() && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), event.getPos()))) != null && !chunk.canInteract((ServerPlayerEntity)event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    private void blockBreak(BlockEvent.BreakEvent event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getWorld(), event.getPos()))) != null && !chunk.canEdit((ServerPlayerEntity)event.getPlayer(), event.getState())) {
            event.setCanceled(true);
        }
    }

    private void blockPlace(BlockEvent.EntityPlaceEvent event) {
        if (this.isValidPlayer(event.getEntity())) {
            if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
                for (BlockSnapshot snapshot : ((BlockEvent.EntityMultiPlaceEvent)event).getReplacedBlockSnapshots()) {
                    ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(snapshot.getWorld(), snapshot.getPos()));
                    if (chunk == null || chunk.canEdit((ServerPlayerEntity)event.getEntity(), snapshot.getCurrentBlock())) continue;
                    event.setCanceled(true);
                    return;
                }
            } else {
                ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getWorld(), event.getPos()));
                if (chunk != null && !chunk.canEdit((ServerPlayerEntity)event.getEntity(), event.getPlacedBlock())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private void fillBucket(FillBucketEvent event) {
        if (this.isValidPlayer((Entity)event.getPlayer()) && event.getTarget() != null && event.getTarget() instanceof BlockRayTraceResult) {
            ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), ((BlockRayTraceResult)event.getTarget()).func_216350_a()));
            Fluid fluid = Fluids.field_204541_a;
            if (event.getEmptyBucket().func_77973_b() instanceof BucketItem) {
                fluid = ((BucketItem)event.getEmptyBucket().func_77973_b()).getFluid();
            }
            if (chunk != null && !chunk.canEdit((ServerPlayerEntity)event.getEntity(), fluid.func_207188_f().func_206883_i())) {
                event.setCanceled(true);
            }
        }
    }

    private void chunkChange(EntityEvent.EnteringChunk event) {
        if (!(event.getEntity() instanceof FakePlayer) && (event.getOldChunkX() != event.getNewChunkX() || event.getOldChunkZ() != event.getNewChunkZ()) && this.isValidPlayer(event.getEntity())) {
            String s;
            ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getEntity()));
            String string = s = chunk == null ? "-" : chunk.getGroupID() + ":" + chunk.getPlayerData().getName();
            if (!event.getEntity().getPersistentData().func_74779_i("ftbchunks_lastchunk").equals(s)) {
                event.getEntity().getPersistentData().func_74778_a("ftbchunks_lastchunk", s);
                if (chunk != null) {
                    ((ServerPlayerEntity)event.getEntity()).func_146105_b(chunk.getDisplayName().func_212638_h().func_211708_a(TextFormatting.AQUA), true);
                } else {
                    ((ServerPlayerEntity)event.getEntity()).func_146105_b(new TranslationTextComponent("wilderness", new Object[0]).func_211708_a(TextFormatting.DARK_GREEN), true);
                }
            }
        }
    }

    private void mobSpawned(LivingSpawnEvent.CheckSpawn event) {
        if (!event.getWorld().func_201670_d() && !(event.getEntity() instanceof PlayerEntity)) {
            switch (event.getSpawnReason()) {
                case NATURAL: 
                case CHUNK_GENERATION: 
                case SPAWNER: 
                case STRUCTURE: 
                case JOCKEY: 
                case PATROL: {
                    ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getWorld().func_201675_m().func_186058_p(), MathHelper.func_76128_c((double)event.getX()), MathHelper.func_76128_c((double)event.getZ())));
                    if (chunk == null || chunk.canEntitySpawn(event.getEntity())) break;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private void explosionDetonate(ExplosionEvent.Detonate event) {
        if (event.getWorld().func_201670_d() || event.getExplosion().func_180343_e().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(event.getExplosion().func_180343_e());
        event.getExplosion().func_180342_d();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos((IWorld)event.getWorld(), pos), cpos -> {
                ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            event.getExplosion().func_180343_e().add(pos);
        }
    }

    static {
        teamsMod = false;
        ranksMod = false;
    }
}

