/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class StandardBlocks {
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_MIPPED = 2L;
    public static final long CFG_TRANSLUCENT = 4L;
    public static final long CFG_WATERLOGGABLE = 8L;
    public static final long CFG_HORIZIONTAL = 16L;
    public static final long CFG_LOOK_PLACEMENT = 32L;
    public static final long CFG_FACING_PLACEMENT = 64L;
    public static final long CFG_OPPOSITE_PLACEMENT = 128L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 256L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 512L;
    public static final long CFG_STRICT_CONNECTIONS = 1024L;

    public static class HorizontalWaterLoggable
    extends Horizontal
    implements IWaterLoggable,
    IStandardBlock {
        public HorizontalWaterLoggable(long config, Block.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L | 0x10L, properties, aabb);
        }

        public HorizontalWaterLoggable(long config, Block.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L | 0x10L, properties, aabbs);
        }

        public HorizontalWaterLoggable(long config, Block.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L | 0x10L, properties, shape_supplier);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{WATERLOGGED});
        }
    }

    public static class DirectedWaterLoggable
    extends Directed
    implements IWaterLoggable,
    IStandardBlock {
        public DirectedWaterLoggable(long config, Block.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L, properties, aabb);
        }

        public DirectedWaterLoggable(long config, Block.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        public DirectedWaterLoggable(long config, Block.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L, properties, shape_supplier);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{WATERLOGGED});
        }
    }

    public static class Horizontal
    extends BaseBlock
    implements IStandardBlock {
        public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
        protected final ArrayList<VoxelShape> vshapes;

        public Horizontal(long config, Block.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 0x10L, properties);
            this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
            this.vshapes = shape_supplier.get();
        }

        public Horizontal(long config, Block.Properties properties, AxisAlignedBB[] unrotatedAABBs) {
            this(config, properties, () -> new ArrayList<VoxelShape>(Arrays.asList(VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.NORTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.WEST, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, true)), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b())));
        }

        public Horizontal(long config, Block.Properties properties, AxisAlignedBB unrotatedAABB) {
            this(config, properties, new AxisAlignedBB[]{unrotatedAABB});
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshapes.get(((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)).func_176745_a() & 7);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.func_220053_a(state, world, pos, selectionContext);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{HORIZONTAL_FACING});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            Direction facing = context.func_196000_l();
            if ((this.config & 0x20L) != 0L) {
                facing = context.func_195992_f();
            } else {
                Direction direction = facing = facing == Direction.UP || facing == Direction.DOWN ? context.func_195992_f() : facing;
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.func_176734_d();
            }
            if ((this.config & 0x200L) != 0L && context.func_195999_j().func_225608_bj_()) {
                facing = facing.func_176734_d();
            }
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)facing);
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)));
        }
    }

    public static class Directed
    extends BaseBlock
    implements IStandardBlock {
        public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
        protected final ArrayList<VoxelShape> vshapes;

        public Directed(long config, Block.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config, properties);
            this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP));
            this.vshapes = shape_supplier.get();
        }

        public Directed(long config, Block.Properties properties, AxisAlignedBB[] unrotatedAABBs) {
            this(config, properties, () -> {
                boolean is_horizontal = (config & 0x10L) != 0L;
                return new ArrayList<VoxelShape>(Arrays.asList(Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.DOWN, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.UP, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.NORTH, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.WEST, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, is_horizontal)), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()));
            });
        }

        public Directed(long config, Block.Properties properties, AxisAlignedBB unrotatedAABB) {
            this(config, properties, new AxisAlignedBB[]{unrotatedAABB});
        }

        @Override
        public boolean func_181623_g() {
            return false;
        }

        public boolean func_220067_a(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> entityType) {
            return false;
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshapes.get(((Direction)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.func_220053_a(state, world, pos, selectionContext);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{FACING});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            Direction facing = context.func_196000_l();
            if ((this.config & 0x30L) == 48L) {
                facing = context.func_195992_f();
            } else if ((this.config & 0x30L) == 16L) {
                if (facing == Direction.UP || facing == Direction.DOWN) {
                    return null;
                }
            } else if ((this.config & 0x20L) != 0L) {
                facing = context.func_196010_d();
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.func_176734_d();
            }
            if ((this.config & 0x200L) != 0L && context.func_195999_j().func_225608_bj_()) {
                facing = facing.func_176734_d();
            }
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)FACING, (Comparable)facing);
        }
    }

    public static class WaterLoggable
    extends BaseBlock
    implements IWaterLoggable,
    IStandardBlock {
        public WaterLoggable(long config, Block.Properties properties) {
            super(config | 8L, properties);
        }

        public WaterLoggable(long config, Block.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L, properties, aabb);
        }

        public WaterLoggable(long config, Block.Properties properties, VoxelShape voxel_shape) {
            super(config | 8L, properties, voxel_shape);
        }

        public WaterLoggable(long config, Block.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{WATERLOGGED});
        }
    }

    public static class BaseBlock
    extends Block
    implements IStandardBlock {
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
        public final long config;
        public final VoxelShape vshape;

        public BaseBlock(long conf, Block.Properties properties) {
            this(conf, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        }

        public BaseBlock(long conf, Block.Properties properties, AxisAlignedBB aabb) {
            super(properties);
            this.config = conf;
            this.vshape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        }

        public BaseBlock(long conf, Block.Properties properties, VoxelShape voxel_shape) {
            super(properties);
            this.config = conf;
            this.vshape = voxel_shape;
        }

        public BaseBlock(long conf, Block.Properties properties, AxisAlignedBB[] aabbs) {
            super(properties);
            this.config = conf;
            VoxelShape shape = VoxelShapes.func_197880_a();
            for (AxisAlignedBB aabb : aabbs) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            this.vshape = shape;
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            return ActionResultType.PASS;
        }

        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
        }

        @Override
        public IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return (this.config & 1L) != 0L ? IStandardBlock.RenderTypeHint.CUTOUT : IStandardBlock.RenderTypeHint.SOLID;
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshape;
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshape;
        }

        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if ((this.config & 8L) != 0L) {
                IFluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
                state = (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
            }
            return state;
        }

        public boolean func_181623_g() {
            return false;
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.NORMAL;
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
                world.func_175713_t(pos);
                world.func_175666_e(pos, (Block)this);
            }
        }

        public static boolean dropBlock(BlockState state, World world, BlockPos pos, @Nullable PlayerEntity player) {
            if (!(state.func_177230_c() instanceof IStandardBlock)) {
                world.func_217377_a(pos, false);
                return true;
            }
            if (!(world.func_201670_d() || player != null && player.func_184812_l_())) {
                ((IStandardBlock)state.func_177230_c()).dropList(state, world, pos, player == null).forEach(stack -> world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack)));
            }
            if (state.func_177230_c().hasTileEntity(state)) {
                world.func_175713_t(pos);
            }
            world.func_217377_a(pos, false);
            return true;
        }

        public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
            return this.hasDynamicDropList() ? BaseBlock.dropBlock(state, world, pos, player) : super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }

        public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
            if (this.hasDynamicDropList()) {
                BaseBlock.dropBlock(world.func_180495_p(pos), world, pos, null);
            }
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            return this.hasDynamicDropList() ? Collections.singletonList(ItemStack.field_190927_a) : super.func_220076_a(state, builder);
        }

        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                return false;
            }
            return super.func_200123_i(state, reader, pos);
        }

        public IFluidState func_204507_t(BlockState state) {
            if ((this.config & 8L) != 0L) {
                return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
            }
            return super.func_204507_t(state);
        }

        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return state;
        }
    }

    public static interface IBlockItemFactory {
        public BlockItem getBlockItem(Block var1, Item.Properties var2);
    }

    public static interface IStandardBlock {
        default public boolean hasDynamicDropList() {
            return false;
        }

        default public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, boolean explosion) {
            return Collections.singletonList(!world.func_201670_d() ? new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()) : ItemStack.field_190927_a);
        }

        default public RenderTypeHint getRenderTypeHint() {
            return RenderTypeHint.SOLID;
        }

        public static enum RenderTypeHint {
            SOLID,
            CUTOUT,
            CUTOUT_MIPPED,
            TRANSLUCENT;

        }
    }
}

