/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdTestBlock {

    public static class TestTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    ICapabilityProvider {
        private int tick_interval_ = 10;
        private int passive_tank_capacity_ = 32000;
        private FluidStack passive_tank_ = FluidStack.EMPTY;
        private FluidStack passive_drain_fluidstack_ = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
        private int passive_drain_max_flowrate_ = 1000;
        private int passive_fill_max_flowrate_ = 1000;
        private int passive_num_drained_general_mb_ = 0;
        private int passive_num_drained_specific_mb_ = 0;
        private int passive_num_filled_specific_mb_ = 0;
        private int passive_num_fh_interactions_ = 0;
        private FluidStack active_fill_fluidstack_ = FluidStack.EMPTY;
        private int active_num_filled_ = 0;
        private int tick_timer_ = 0;
        private LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new MainFluidHandler(this));

        public TestTileEntity() {
            this(ModContent.TET_TEST_BLOCK);
        }

        public TestTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        private Direction block_facing() {
            BlockState st = this.func_145831_w().func_180495_p(this.func_174877_v());
            return st.func_177230_c() instanceof TestBlock ? (Direction)st.func_177229_b((IProperty)TestBlock.FACING) : Direction.NORTH;
        }

        private String dump_fluid_stack(FluidStack fs) {
            String s = "";
            if (fs.getFluid().getRegistryName().func_110624_b() != "minecraft") {
                s = s + fs.getFluid().getRegistryName().func_110624_b() + ":";
            }
            s = s + fs.getFluid().getRegistryName().func_110623_a();
            s = s + " x" + fs.getAmount();
            return "[" + s + "]";
        }

        public void activated(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            if (this.field_145850_b.func_201670_d()) {
                return;
            }
            ItemStack held_stack = player.func_184586_b(hand);
            if (held_stack.func_190926_b()) {
                String message = "";
                if (this.passive_num_filled_specific_mb_ > 0 || this.passive_num_drained_specific_mb_ > 0 || this.passive_num_drained_general_mb_ > 0) {
                    message = message + "Fluid handler: filled:" + this.passive_num_filled_specific_mb_ + ", drained:" + (this.passive_num_drained_specific_mb_ + this.passive_num_drained_general_mb_) + ", interactions:" + this.passive_num_fh_interactions_ + "\n";
                }
                if (this.active_num_filled_ > 0) {
                    message = message + "Fluid insertion:" + this.active_num_filled_ + "mb, (current:" + this.dump_fluid_stack(this.active_fill_fluidstack_) + ")\n";
                }
                if (message.isEmpty()) {
                    message = "No fluid, energy, or item interactions done yet.";
                }
                Auxiliaries.playerChatMessage(player, message);
                return;
            }
            IFluidHandlerItem fhi = (IFluidHandlerItem)held_stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
            if (fhi != null) {
                int ntanks = fhi.getTanks();
                if (ntanks == 0) {
                    return;
                }
                int capacity = fhi.getTankCapacity(0);
                FluidStack fs = fhi.drain(capacity, IFluidHandler.FluidAction.SIMULATE);
                if (!fs.isEmpty()) {
                    if (this.active_fill_fluidstack_.isEmpty()) {
                        this.active_fill_fluidstack_ = fs.copy();
                        Auxiliaries.playerChatMessage(player, "Fluid insertion fluid set: " + this.dump_fluid_stack(this.active_fill_fluidstack_));
                    } else if (fs.isFluidEqual(this.active_fill_fluidstack_)) {
                        this.active_fill_fluidstack_.grow(fs.getAmount());
                        Auxiliaries.playerChatMessage(player, "Fluid insertion flowrate increased: " + this.dump_fluid_stack(this.active_fill_fluidstack_));
                    } else {
                        int amount = this.active_fill_fluidstack_.getAmount();
                        this.active_fill_fluidstack_ = fs.copy();
                        this.active_fill_fluidstack_.setAmount(amount);
                        Auxiliaries.playerChatMessage(player, "Fluid insertion fluid changed: " + this.dump_fluid_stack(this.active_fill_fluidstack_));
                    }
                } else if (!this.active_fill_fluidstack_.isEmpty()) {
                    this.active_fill_fluidstack_.shrink(1000);
                    if (this.active_fill_fluidstack_.isEmpty()) {
                        this.active_fill_fluidstack_ = FluidStack.EMPTY;
                    }
                    Auxiliaries.playerChatMessage(player, "Fluid insertion flowrate decreased: " + this.dump_fluid_stack(this.active_fill_fluidstack_));
                } else {
                    Auxiliaries.playerChatMessage(player, "Fluid insertion disabled.");
                }
                this.passive_drain_fluidstack_ = this.active_fill_fluidstack_.copy();
                return;
            }
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            if (nbt.func_74764_b("passive_tank")) {
                this.passive_tank_ = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("passive_tank"));
            }
            if (nbt.func_74764_b("passive_drain")) {
                this.passive_drain_fluidstack_ = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("passive_drain"));
            }
            if (nbt.func_74764_b("active")) {
                this.active_fill_fluidstack_ = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("active"));
            }
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            if (!this.passive_tank_.isEmpty()) {
                nbt.func_218657_a("passive_tank", (INBT)this.passive_tank_.writeToNBT(new CompoundNBT()));
            }
            if (!this.passive_drain_fluidstack_.isEmpty()) {
                nbt.func_218657_a("passive_drain", (INBT)this.passive_drain_fluidstack_.writeToNBT(new CompoundNBT()));
            }
            if (!this.active_fill_fluidstack_.isEmpty()) {
                nbt.func_218657_a("active", (INBT)this.active_fill_fluidstack_.writeToNBT(new CompoundNBT()));
            }
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.fluid_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                if (facing != this.block_facing()) {
                    return this.fluid_handler_.cast();
                }
                return LazyOptional.empty();
            }
            return super.getCapability(capability, facing);
        }

        private void fluid_insertion() {
            if (this.active_fill_fluidstack_.isEmpty()) {
                return;
            }
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing()));
            if (te == null) {
                return;
            }
            IFluidHandler fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.block_facing().func_176734_d()).orElse(null);
            if (fh == null) {
                return;
            }
            int filled = fh.fill(this.active_fill_fluidstack_.copy(), IFluidHandler.FluidAction.EXECUTE);
            this.active_num_filled_ += filled;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = this.tick_interval_ = MathHelper.func_76125_a((int)this.tick_interval_, (int)1, (int)200);
            this.fluid_insertion();
        }

        private static class MainFluidHandler
        implements IFluidHandler {
            private TestTileEntity te;

            public MainFluidHandler(TestTileEntity te) {
                this.te = te;
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return this.te.passive_tank_capacity_;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                ++this.te.passive_num_fh_interactions_;
                if (resource.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                if (!resource.isFluidEqual(this.te.passive_drain_fluidstack_)) {
                    return FluidStack.EMPTY;
                }
                FluidStack st = resource.copy();
                st.setAmount(MathHelper.func_76125_a((int)st.getAmount(), (int)0, (int)this.te.passive_drain_max_flowrate_));
                if (st.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    TestTileEntity testTileEntity = this.te;
                    testTileEntity.passive_num_drained_specific_mb_ = testTileEntity.passive_num_drained_specific_mb_ + st.getAmount();
                }
                return st;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                ++this.te.passive_num_fh_interactions_;
                maxDrain = MathHelper.func_76125_a((int)maxDrain, (int)0, (int)this.te.passive_drain_max_flowrate_);
                if (this.te.passive_drain_fluidstack_.isEmpty() || maxDrain <= 0) {
                    return FluidStack.EMPTY;
                }
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    TestTileEntity testTileEntity = this.te;
                    testTileEntity.passive_num_drained_general_mb_ = testTileEntity.passive_num_drained_general_mb_ + maxDrain;
                }
                FluidStack st = this.te.passive_drain_fluidstack_.copy();
                st.setAmount(maxDrain);
                return st;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return true;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                ++this.te.passive_num_fh_interactions_;
                int amount = MathHelper.func_76125_a((int)resource.getAmount(), (int)0, (int)this.te.passive_fill_max_flowrate_);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    TestTileEntity testTileEntity = this.te;
                    testTileEntity.passive_num_filled_specific_mb_ = testTileEntity.passive_num_filled_specific_mb_ + amount;
                    if (this.te.passive_tank_.isFluidEqual(resource)) {
                        int level = (int)MathHelper.func_226163_a_((long)((long)this.te.passive_tank_.getAmount() + (long)amount), (long)0L, (long)Integer.MAX_VALUE);
                        this.te.passive_tank_.setAmount(level);
                    }
                }
                return amount;
            }
        }
    }

    public static class TestBlock
    extends DecorBlock.Directed
    implements Auxiliaries.IExperimentalFeature,
    IDecorBlock {
        public TestBlock(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return VoxelShapes.func_197868_b();
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TestTileEntity();
        }

        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, boolean explosion) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((IItemProvider)this, 1));
            return list;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TestTileEntity)) {
                return ActionResultType.SUCCESS;
            }
            ((TestTileEntity)te).activated(player, hand, hit);
            return ActionResultType.SUCCESS;
        }
    }
}

