/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import java.util.HashMap;
import java.util.Map;
import journeymap.server.properties.DefaultDimensionProperties;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import net.minecraft.world.dimension.DimensionType;

public class PropertiesManager {
    private static PropertiesManager INSTANCE;
    private Map<Integer, DimensionProperties> dimensionProperties;
    private GlobalProperties globalProperties;
    private DefaultDimensionProperties defaultDimensionProperties;

    public static PropertiesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PropertiesManager();
            INSTANCE.loadConfigs();
        }
        return INSTANCE;
    }

    private void loadConfigs() {
        this.dimensionProperties = new HashMap<Integer, DimensionProperties>();
        this.globalProperties = new GlobalProperties();
        this.globalProperties.load();
        this.defaultDimensionProperties = new DefaultDimensionProperties();
        this.defaultDimensionProperties.load();
        for (DimensionType dim : DimensionType.func_212681_b()) {
            this.genConfig(dim.func_186068_a());
        }
    }

    public DimensionProperties getDimProperties(int dim) {
        if (this.dimensionProperties.get(dim) == null) {
            this.genConfig(dim);
        }
        return this.dimensionProperties.get(dim);
    }

    public DefaultDimensionProperties getDefaultDimensionProperties() {
        return this.defaultDimensionProperties;
    }

    public GlobalProperties getGlobalProperties() {
        return this.globalProperties;
    }

    private void genConfig(int dim) {
        DimensionProperties prop = new DimensionProperties(dim);
        this.dimensionProperties.put(dim, prop);
        if (!prop.getFile().exists()) {
            prop.build();
        }
        prop.load();
    }
}

