/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.api.biome.modifier.BiomeModifier;
import com.terraforged.api.biome.modifier.ModifierManager;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.modifier.BeachModifier;
import com.terraforged.mod.biome.modifier.DesertColorModifier;
import com.terraforged.mod.biome.modifier.SandBiomeModifier;
import com.terraforged.mod.biome.provider.DesertBiomes;
import com.terraforged.mod.chunk.TerraContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class BiomeModifierManager
implements BiomeModifier,
ModifierManager {
    private final DesertBiomes desertBiomes;
    private final List<BiomeModifier> biomeModifiers;

    public BiomeModifierManager(TerraContext context, BiomeMap biomes) {
        this.desertBiomes = new DesertBiomes(context.materials, biomes.getAllBiomes(BiomeType.DESERT));
        ArrayList<BiomeModifier> modifiers = new ArrayList<BiomeModifier>();
        modifiers.add(new BeachModifier(biomes, context.terrain));
        modifiers.add(new DesertColorModifier(this.desertBiomes));
        modifiers.add(new SandBiomeModifier(context.seed, context.factory.getClimate(), context.levels));
        Collections.sort(modifiers);
        this.biomeModifiers = modifiers;
    }

    @Override
    public void register(BiomeModifier modifier) {
        this.biomeModifiers.add(modifier);
        Collections.sort(this.biomeModifiers);
    }

    public DesertBiomes getDesertBiomes() {
        return this.desertBiomes;
    }

    @Override
    public int priority() {
        return -1;
    }

    @Override
    public boolean test(Biome biome) {
        return true;
    }

    @Override
    public Biome modify(Biome biome, Cell<Terrain> cell, int x, int z) {
        for (BiomeModifier modifier : this.biomeModifiers) {
            if (!modifier.test(biome)) continue;
            biome = modifier.modify(biome, cell, x, z);
        }
        return biome;
    }
}

